/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.msal;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.graph.models.User;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.extrausermgt.authentication.msal.AbstractMSALCredentialProvider;
import org.ametys.plugins.extrausermgt.authentication.msal.OIDCScopesExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class EntraIDCredentialProvider
extends AbstractMSALCredentialProvider
implements Serviceable {
    private String _tenant;
    private String _loginAttribute;
    private OIDCScopesExtensionPoint _scopesExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._scopesExtensionPoint = (OIDCScopesExtensionPoint)manager.lookup(OIDCScopesExtensionPoint.ROLE);
    }

    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, cpModelId, paramValues, label);
        this._tenant = (String)paramValues.get("authentication.entraid.tenant");
        String clientID = (String)paramValues.get("authentication.entraid.appid");
        String clientSecret = (String)paramValues.get("authentication.entraid.clientsecret");
        boolean silent = (Boolean)paramValues.get("authentication.entraid.silent");
        boolean prompt = (Boolean)paramValues.get("authentication.entraid.prompt");
        this.init(clientID, clientSecret, prompt, silent);
        this._loginAttribute = (String)paramValues.get("authentication.entraid.loginattribute");
    }

    @Override
    protected String getAuthority() {
        return "https://login.microsoftonline.com/" + this._tenant;
    }

    @Override
    protected Set<String> getScopes() {
        return this._scopesExtensionPoint.getScopes();
    }

    @Override
    protected String getLogin(IAuthenticationResult result) {
        ClientSecretCredential clientSecretCredential;
        GraphServiceClient graphClient;
        User user;
        String upn = result.account().username();
        if (this._loginAttribute.equals("onPremisesSamAccountName") && (user = (graphClient = new GraphServiceClient((TokenCredential)(clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this._clientID)).clientSecret(this._clientSecret).tenantId(this._tenant)).build()), new String[0])).users().byUserId(upn).get(requestConfiguration -> {
            requestConfiguration.queryParameters.select = new String[]{"onPremisesSamAccountName"};
        })) != null && StringUtils.isNotBlank((CharSequence)user.getOnPremisesSamAccountName())) {
            return user.getOnPremisesSamAccountName();
        }
        return upn;
    }
}

