/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.ametys.plugins.extrausermgt.authentication.oidc.AbstractOIDCCredentialProvider;
import org.ametys.runtime.authentication.AccessDeniedException;

public class FacebookCredentialProvider
extends AbstractOIDCCredentialProvider {
    private final Scope _scopeFb = new Scope(new String[]{"openid", "email", "public_profile"});

    @Override
    protected void initUrisScope() throws AccessDeniedException {
        try {
            this._authUri = URI.create("https://www.facebook.com/v13.0/dialog/oauth");
            this._tokenEndpointUri = URI.create("https://graph.facebook.com/v13.0/oauth/access_token");
            this._iss = new Issuer("https://www.facebook.com");
            this._jwkSetURL = new URI("https://www.facebook.com/.well-known/oauth/openid/jwks/").toURL();
            this._userInfoEndpoint = URI.create("https://graph.facebook.com/me?fields=email,family_name,given_name,name,id");
            this._scope = this._scopeFb;
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.getLogger().error("Encountered a problem when creating the jwkSetURL", (Throwable)e);
            throw new AccessDeniedException("Encountered a problem when creating the jwkSetURL");
        }
    }
}

