/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.ametys.plugins.extrausermgt.authentication.oidc.AbstractOIDCCredentialProvider;
import org.ametys.runtime.authentication.AccessDeniedException;

public class GenericOIDCCredentialProvider
extends AbstractOIDCCredentialProvider {
    @Override
    protected void initUrisScope() throws AccessDeniedException {
        Map paramValues = this.getParameterValues();
        try {
            this._authUri = URI.create((String)paramValues.get("authentication.oidc.authUri"));
            this._tokenEndpointUri = URI.create((String)paramValues.get("authentication.oidc.tokenEndpointUri"));
            this._iss = new Issuer((String)paramValues.get("authentication.oidc.issuer"));
            this._jwkSetURL = new URI((String)paramValues.get("authentication.oidc.jwkSetURL")).toURL();
            this._userInfoEndpoint = URI.create((String)paramValues.get("authentication.oidc.userInfoEndpoint"));
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.getLogger().error("Encountered a problem when creating the jwkSetURL", (Throwable)e);
            throw new AccessDeniedException("Encountered a problem when creating the jwkSetURL");
        }
        this._scope = Scope.parse((String)((String)paramValues.get("authentication.oidc.scopes")));
        this._scope.add((Object)OIDCScopeValue.OPENID);
    }
}

