/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.oauth;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import java.io.IOException;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ParseException;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.SessionAttributeProvider;
import org.ametys.plugins.extrausermgt.oauth.OAuthProvider;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;

public class DefaultOauthProvider
extends AbstractLogEnabled
implements OAuthProvider,
Configurable,
Serviceable,
Contextualizable {
    public static final String OAUTH_STATE_SESSION_ATTRIBUTE = "oauth.state";
    public static final String OAUTH_REDIRECT_URI_SESSION_ATTRIBUTE = "oauth.redirect.uri";
    public static final String OAUTH_ACCESS_TOKEN_SESSION_ATTRIBUTE = "oauth.access.token";
    public static final String OAUTH_ACCESS_TOKEN_EXPIRATION_DATE_SESSION_ATTRIBUTE = "oauth.access.token.expiration.date";
    public static final String OAUTH_REFRESH_TOKEN_SESSION_ATTRIBUTE = "oauth.refresh.token";
    public static final String OAUTH_CUSTOM_PARAMETER = "oauth.custom.parameter";
    private static final String __OAUTH_AUTHORIZATION_CALLBACK = "/_extra-user-management/oauth-callback";
    protected String _id;
    protected ClientID _clientID;
    protected ClientAuthentication _auth;
    protected URI _authorizationEnpoint;
    protected URI _tokenEndpointURI;
    protected Scope _scope;
    protected Set<String> _customParameters;
    private SessionAttributeProvider _sessionAttributeProvider;
    private Set<State> _knownState = new HashSet<State>();
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sessionAttributeProvider = (SessionAttributeProvider)manager.lookup(SessionAttributeProvider.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._id = configuration.getAttribute("id");
        this._clientID = new ClientID(this._getConfigValue(configuration.getChild("clientId")));
        this._auth = new ClientSecretBasic(this._clientID, new Secret(this._getConfigValue(configuration.getChild("secret"))));
        String baseURL = this._getConfigValue(configuration.getChild("baseURL"));
        if (StringUtils.isNotEmpty((CharSequence)baseURL)) {
            this._authorizationEnpoint = URI.create(baseURL + this._getConfigValue(configuration.getChild("authorizationEndpointPath")));
            this._tokenEndpointURI = URI.create(baseURL + this._getConfigValue(configuration.getChild("tokenEndpointPath")));
        } else {
            this._authorizationEnpoint = URI.create(this._getConfigValue(configuration.getChild("authorizationEndpointURI")));
            this._tokenEndpointURI = URI.create(this._getConfigValue(configuration.getChild("tokenEndpointURI")));
        }
        this._scope = new Scope();
        String scopes = this._getConfigValue(configuration.getChild("scopes"));
        for (String scope : StringTokenizer.getCSVInstance((String)scopes).getTokenList()) {
            this._scope.add(scope);
        }
        String customParams = this._getConfigValue(configuration.getChild("customParams"));
        this._customParameters = new HashSet<String>(StringTokenizer.getCSVInstance((String)customParams).getTokenList());
    }

    protected String _getConfigValue(Configuration cfg) {
        if (cfg.getAttributeAsBoolean("config", false)) {
            return (String)Config.getInstance().getValue(cfg.getValue(""));
        }
        return cfg.getValue(null);
    }

    @Override
    public ClientID getClientID() {
        return this._clientID;
    }

    @Override
    public URI getAuthorizationEndpointURI() {
        return this._authorizationEnpoint;
    }

    @Override
    public URI getTokenEndpointURI() {
        return this._tokenEndpointURI;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public ClientAuthentication getClientAuthentication() {
        return this._auth;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    @Override
    public Set<String> getCustomParametersName() {
        return this._customParameters;
    }

    @Override
    public boolean isKnownState(State state) {
        return this._knownState.remove(state);
    }

    @Override
    public Optional<AccessToken> getStoredAccessToken() {
        Optional<AccessToken> accessToken = this._sessionAttributeProvider.getSessionAttribute("oauth.access.token$" + this._id).map(s -> {
            try {
                return AccessToken.parse((JSONObject)((JSONObject)JSONValue.parseWithException((String)((String)s))));
            }
            catch (com.nimbusds.oauth2.sdk.ParseException | ParseException e) {
                this.getLogger().warn("Failed to parse the stored access token for provider {}. The token is ignored", (Object)this._id, (Object)e);
                return null;
            }
        });
        if (accessToken.isEmpty()) {
            return accessToken;
        }
        Optional<ZonedDateTime> expirationDate = this._sessionAttributeProvider.getSessionAttribute("oauth.access.token.expiration.date$" + this._id).map(str -> DateUtils.parseZonedDateTime((String)((String)str)));
        if (expirationDate.isEmpty()) {
            this.getLogger().warn("A token is stored in session for provider {} but the token has no expiration date or an invalid one. The token is ignored.", (Object)this._id);
            return Optional.empty();
        }
        if (ZonedDateTime.now().isBefore(expirationDate.get())) {
            return accessToken;
        }
        return this._refreshToken();
    }

    private Optional<AccessToken> _refreshToken() {
        Optional tokenAttribute = this._sessionAttributeProvider.getSessionAttribute("oauth.refresh.token$" + this._id);
        Optional<RefreshToken> refreshToken = tokenAttribute.map(str -> {
            try {
                return RefreshToken.parse((JSONObject)((JSONObject)JSONValue.parseWithException((String)((String)str))));
            }
            catch (com.nimbusds.oauth2.sdk.ParseException | ParseException e) {
                this.getLogger().warn("Failed to parse the stored refresh token for provider {}. The token is ignored", (Object)this._id, (Object)e);
                return null;
            }
        });
        if (refreshToken.isPresent()) {
            RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken.get());
            try {
                return Optional.of(this.requestAccessToken((AuthorizationGrant)refreshTokenGrant));
            }
            catch (IOException | AccessDeniedException e) {
                this.getLogger().warn("Failed to refresh access token for provider {}", (Object)this._id, (Object)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> getStoredCustomParameter(String parameter) {
        Optional sessionAttribute = this._sessionAttributeProvider.getSessionAttribute("oauth.custom.parameter$" + this._id + "#" + parameter);
        return sessionAttribute.map(str -> JSONValue.parse((String)((String)str)));
    }

    @Override
    public Optional<AccessToken> getAccessToken(Redirector redirector) throws ProcessingException, IOException {
        Optional<AccessToken> accessToken = this.getStoredAccessToken();
        if (accessToken.isPresent()) {
            return accessToken;
        }
        AuthorizationRequest authRequest = this.buildAuthorizationCodeRequest();
        if (!redirector.hasRedirected()) {
            redirector.redirect(false, authRequest.toURI().toString());
        }
        return Optional.empty();
    }

    protected AuthorizationRequest buildAuthorizationCodeRequest() {
        State state = this._generateState();
        AuthorizationRequest.Builder authorizationRequestBuilder = new AuthorizationRequest.Builder(ResponseType.CODE, this._clientID).endpointURI(this._authorizationEnpoint).redirectionURI(this._getRedirectUri()).state(state);
        if (!this._scope.isEmpty()) {
            authorizationRequestBuilder.scope(this._scope);
        }
        return authorizationRequestBuilder.build();
    }

    protected State _generateState() {
        State state = new State();
        while (!this._knownState.add(state)) {
            state = new State();
        }
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession();
        session.setAttribute(OAUTH_STATE_SESSION_ATTRIBUTE, (Object)state);
        return state;
    }

    private URI _getRedirectUri() {
        Request request = ContextHelper.getRequest((Context)this._context);
        this._storeCurrentRequestUriInSession(request);
        return this._buildAbsoluteURI(request, __OAUTH_AUTHORIZATION_CALLBACK);
    }

    private void _storeCurrentRequestUriInSession(Request request) {
        StringBuilder actualRedirectUri = new StringBuilder(request.getRequestURI());
        String queryString = request.getQueryString();
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            actualRedirectUri.append("?");
            actualRedirectUri.append(queryString);
        }
        Session session = request.getSession(true);
        session.setAttribute(OAUTH_REDIRECT_URI_SESSION_ATTRIBUTE, (Object)actualRedirectUri.toString());
    }

    private URI _buildAbsoluteURI(Request request, String path) {
        StringBuilder uriBuilder = new StringBuilder().append(request.getScheme()).append("://").append(request.getServerName());
        if (request.isSecure()) {
            if (request.getServerPort() != 443) {
                uriBuilder.append(":");
                uriBuilder.append(request.getServerPort());
            }
        } else if (request.getServerPort() != 80) {
            uriBuilder.append(":");
            uriBuilder.append(request.getServerPort());
        }
        uriBuilder.append(request.getContextPath());
        uriBuilder.append(path);
        return URI.create(uriBuilder.toString());
    }

    @Override
    public AccessToken requestAccessToken(AuthorizationGrant authorizationGrant) throws IOException {
        TokenRequest tokenRequest = new TokenRequest(this.getTokenEndpointURI(), this.getClientAuthentication(), authorizationGrant, this.getScope());
        ZonedDateTime requestDate = ZonedDateTime.now();
        HTTPResponse httpResponse = tokenRequest.toHTTPRequest().send();
        return this._getAccessTokenFromAuthorizationServerResponse(httpResponse, requestDate);
    }

    protected AccessToken _getAccessTokenFromAuthorizationServerResponse(HTTPResponse httpResponse, ZonedDateTime requestDate) {
        TokenResponse tokenResponse;
        try {
            tokenResponse = TokenResponse.parse((HTTPResponse)httpResponse);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            this.getLogger().error("Token response is invalid. Access will be denied", (Throwable)e);
            throw new AccessDeniedException("Oauth authorization request failed with invalid response. The response was not parseable");
        }
        if (tokenResponse.indicatesSuccess()) {
            AccessTokenResponse successResponse = tokenResponse.toSuccessResponse();
            return this.storeTokens(successResponse, requestDate);
        }
        ErrorObject errorObject = tokenResponse.toErrorResponse().getErrorObject();
        throw new AccessDeniedException("Oauth authorization request failed with http status '" + errorObject.getHTTPStatusCode() + "', code '" + errorObject.getCode() + "' and description '" + errorObject.getDescription() + "'.");
    }

    protected AccessToken storeTokens(AccessTokenResponse response, ZonedDateTime requestDate) {
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession();
        Tokens tokens = response.getTokens();
        AccessToken accessToken = tokens.getAccessToken();
        session.setAttribute("oauth.access.token$" + this._id, (Object)accessToken.toJSONObject().toJSONString());
        session.setAttribute("oauth.refresh.token$" + this._id, (Object)tokens.getRefreshToken().toJSONObject().toJSONString());
        if (accessToken.getLifetime() != 0L) {
            session.setAttribute("oauth.access.token.expiration.date$" + this._id, (Object)DateUtils.zonedDateTimeToString((ZonedDateTime)requestDate.plusSeconds(accessToken.getLifetime())));
        }
        Map customParameters = response.getCustomParameters();
        for (String paramName : this.getCustomParametersName()) {
            Object param = customParameters.get(paramName);
            session.setAttribute("oauth.custom.parameter$" + this._id + "#" + paramName, (Object)JSONValue.toJSONString(param));
        }
        return accessToken;
    }
}

