/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.cas;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.component.Component;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.slf4j.LoggerFactory;

import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * CAS Proxy Granting Ticket manager, correlating PGTIOU with PGT
 */
public class CasProxyGrantingTicketManager extends AbstractLogEnabled implements ProxyGrantingTicketStorage, Component
{
    /** Avalon role */
    public static final String ROLE = CasProxyGrantingTicketManager.class.getName();
    
    private static Map<String, String> _internalMap = new HashMap<>();
    
    /**
     * Constructor for the instance not created by Avalon, but by AmetysCas20ProxyReceivingTicketValidationFilter
     */
    public CasProxyGrantingTicketManager()
    {
        setLogger(LoggerFactory.getLogger(getClass()));
    }
    
    @Override
    public void save(String proxyGrantingTicketIou, String proxyGrantingTicket)
    {
        getLogger().debug("Save proxyGrantingTicket '{}' for proxyGrantingTicketIou '{}'", proxyGrantingTicket, proxyGrantingTicketIou);
        _internalMap.put(proxyGrantingTicketIou, proxyGrantingTicket);
    }
    
    @Override
    public String retrieve(String proxyGrantingTicketIou)
    {
        String proxyGrantingTicket = _internalMap.get(proxyGrantingTicketIou);
        getLogger().debug("Retrieve proxyGrantingTicket for proxyGrantingTicketIou '{}'. Its returned value is '{}'", proxyGrantingTicketIou, proxyGrantingTicket);
        return proxyGrantingTicket;
    }
    
    @Override
    public void cleanUp()
    {
        getLogger().debug("Cleaning up");
        _internalMap.clear();
    }
}
