/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.msal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.ametys.plugins.extrausermgt.authentication.msal.AbstractMSALCredentialProvider;

public class ADFSCredentialProvider
extends AbstractMSALCredentialProvider {
    private String _adfsServer;

    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, cpModelId, paramValues, label);
        this._adfsServer = (String)paramValues.get("authentication.adfs.url");
        String clientID = (String)paramValues.get("authentication.adfs.appid");
        String clientSecret = (String)paramValues.get("authentication.adfs.clientsecret");
        boolean silent = (Boolean)paramValues.get("authentication.adfs.silent");
        this.init(clientID, clientSecret, false, silent);
    }

    @Override
    protected String getAuthority() {
        return this._adfsServer;
    }

    @Override
    public String getIssuer() {
        return this.getAuthority();
    }

    @Override
    public URL getJwkSetURL() {
        try {
            return new URI(this.getAuthority() + "/discovery/keys").toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid JWKSetURL", e);
        }
    }
}

