/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.NonBlockingCredentialProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.plugins.extrausermgt.authentication.oidc.OIDCBasedCredentialProvider;
import org.ametys.plugins.extrausermgt.authentication.oidc.endofauthenticationprocess.EndOfAuthenticationProcess;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractOIDCCredentialProvider
extends AbstractCredentialProvider
implements OIDCBasedCredentialProvider,
BlockingCredentialProvider,
NonBlockingCredentialProvider,
Contextualizable,
Serviceable {
    public static final String REDIRECT_URI_SESSION_ATTRIBUTE = "oidc_actualRedirectUri";
    public static final String TOKEN_SESSION_ATTRIBUTE = "oidc_token";
    public static final String EXPDATE_SESSION_ATTRIBUTE = "oidc_expirationDate";
    public static final String REFRESH_TOKEN_SESSION_ATTRIBUTE = "oidc_refreshToken";
    public static final String STATE_SESSION_ATTRIBUTE = "oidc_state";
    private static final String __ATTRIBUTE_SILENT = "oidc_silent";
    protected Scope _scope;
    protected URI _authUri;
    protected URI _tokenEndpointUri;
    protected URI _userInfoEndpoint;
    protected URL _jwkSetURL;
    protected Issuer _iss;
    protected Context _context;
    protected ClientID _clientID;
    protected Secret _clientSecret;
    protected boolean _silent;
    private EndOfAuthenticationProcess _endOfAuthenticationProcess;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._endOfAuthenticationProcess = (EndOfAuthenticationProcess)((Object)manager.lookup(EndOfAuthenticationProcess.ROLE));
    }

    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, cpModelId, paramValues, label);
        this._clientID = new ClientID(paramValues.get("authentication.oidc.idclient").toString());
        this._clientSecret = new Secret(paramValues.get("authentication.oidc.clientsecret").toString());
        this._silent = (Boolean)paramValues.get("authentication.oidc.silent");
        this.initUrisScope();
    }

    @Override
    public String getClientId() {
        return this._clientID.getValue();
    }

    @Override
    public String getIssuer() {
        return this._iss.getValue();
    }

    @Override
    public URL getJwkSetURL() {
        return this._jwkSetURL;
    }

    protected ClientAuthentication getClientAuthentication() {
        return new ClientSecretBasic(this._clientID, this._clientSecret);
    }

    public boolean blockingGrantAnonymousRequest() {
        return false;
    }

    public boolean nonBlockingGrantAnonymousRequest() {
        return false;
    }

    public boolean blockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession(true);
        Date expDat = (Date)session.getAttribute(EXPDATE_SESSION_ATTRIBUTE);
        if (new Date().before(expDat)) {
            return true;
        }
        RefreshToken refreshToken = (RefreshToken)session.getAttribute(REFRESH_TOKEN_SESSION_ATTRIBUTE);
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
        ClientAuthentication clientAuth = this.getClientAuthentication();
        OIDCTokens tokens = this.requestToken(clientAuth, (AuthorizationGrant)refreshTokenGrant);
        JWT idToken = tokens.getIDToken();
        AccessToken accessToken = tokens.getAccessToken();
        IDTokenClaimsSet claims = this.validateIdToken(idToken);
        session.setAttribute(EXPDATE_SESSION_ATTRIBUTE, (Object)claims.getExpirationTime());
        session.setAttribute(TOKEN_SESSION_ATTRIBUTE, (Object)accessToken);
        return true;
    }

    public boolean nonBlockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        return this.blockingIsStillConnected(userIdentity, redirector);
    }

    private UserIdentity _login(boolean silent, Redirector redirector) throws Exception {
        String code;
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession(true);
        URI redirectUri = this._buildRedirectUri();
        this.getLogger().debug("OIDCCredentialProvider callback URI: {}", (Object)redirectUri);
        boolean wasSilent = false;
        if (silent) {
            wasSilent = "true".equals(session.getAttribute(__ATTRIBUTE_SILENT));
        }
        if ((code = request.getParameter("code")) == null || session.getAttribute(STATE_SESSION_ATTRIBUTE) == null) {
            this.signIn(redirector, redirectUri, silent, wasSilent, session);
            return null;
        }
        this.checkState();
        AuthorizationCode authCode = new AuthorizationCode(code);
        OIDCTokens tokens = this.requestToken(authCode, redirectUri);
        JWT idToken = tokens.getIDToken();
        AccessToken accessToken = tokens.getAccessToken();
        RefreshToken refreshToken = tokens.getRefreshToken();
        session.setAttribute(REFRESH_TOKEN_SESSION_ATTRIBUTE, (Object)refreshToken);
        IDTokenClaimsSet claims = this.validateIdToken(idToken);
        claims.getExpirationTime();
        session.setAttribute(EXPDATE_SESSION_ATTRIBUTE, (Object)claims.getExpirationTime());
        UserInfo userInfo = this.getUserInfo(accessToken);
        return this.getUserIdentity(userInfo, request, redirector);
    }

    public UserIdentity blockingGetUserIdentity(Redirector redirector) throws Exception {
        return this._login(false, redirector);
    }

    public UserIdentity nonBlockingGetUserIdentity(Redirector redirector) throws Exception {
        if (!this._silent) {
            return null;
        }
        return this._login(true, redirector);
    }

    public void blockingUserNotAllowed(Redirector redirector) throws Exception {
    }

    public void nonBlockingUserNotAllowed(Redirector redirector) throws Exception {
    }

    public void blockingUserAllowed(UserIdentity userIdentity, Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession(true);
        String redirectUri = (String)session.getAttribute(REDIRECT_URI_SESSION_ATTRIBUTE);
        redirector.redirect(true, redirectUri);
    }

    public void nonBlockingUserAllowed(UserIdentity userIdentity, Redirector redirector) throws Exception {
        this.blockingUserAllowed(userIdentity, redirector);
    }

    public boolean requiresNewWindow() {
        return true;
    }

    private UserPopulation _getPopulation(Request request) {
        List userPopulations = (List)request.getAttribute("Runtime:UserPopulationsList");
        if (userPopulations.size() == 1) {
            return (UserPopulation)userPopulations.get(0);
        }
        String chosenUserPopulationId = (String)request.getAttribute("Runtime:CurrentUserPopulationId");
        if (StringUtils.isNotBlank((CharSequence)chosenUserPopulationId)) {
            return userPopulations.stream().filter(userPopulation -> StringUtils.equals((CharSequence)userPopulation.getId(), (CharSequence)chosenUserPopulationId)).findFirst().get();
        }
        throw new IllegalStateException("The " + this.getClass().getName() + " does not work when population is not known");
    }

    protected abstract void initUrisScope() throws AccessDeniedException;

    private URI _buildRedirectUri() throws URISyntaxException {
        Request request = ContextHelper.getRequest((Context)this._context);
        StringBuilder actualRedirectUri = new StringBuilder(request.getRequestURI());
        String queryString = request.getQueryString();
        if (queryString != null && StringUtils.isNotEmpty((CharSequence)(queryString = Stream.of(StringUtils.split((String)queryString, (String)"&")).filter(str -> !StringUtils.startsWithAny((CharSequence)str, (CharSequence[])new CharSequence[]{"code=", "state="})).collect(Collectors.joining("&"))))) {
            actualRedirectUri.append("?");
            actualRedirectUri.append(queryString);
        }
        Session session = request.getSession(true);
        session.setAttribute(REDIRECT_URI_SESSION_ATTRIBUTE, (Object)actualRedirectUri.toString());
        return this.buildAbsoluteURI(request, "/_extra-user-management/oidc-callback");
    }

    protected URI buildAbsoluteURI(Request request, String path) {
        StringBuilder uriBuilder = new StringBuilder().append(request.getScheme()).append("://").append(request.getServerName());
        if (request.isSecure()) {
            if (request.getServerPort() != 443) {
                uriBuilder.append(":");
                uriBuilder.append(request.getServerPort());
            }
        } else if (request.getServerPort() != 80) {
            uriBuilder.append(":");
            uriBuilder.append(request.getServerPort());
        }
        uriBuilder.append(request.getContextPath());
        uriBuilder.append(path);
        return URI.create(uriBuilder.toString());
    }

    protected void signIn(Redirector redirector, URI redirectUri, boolean silent, boolean wasSilent, Session session) throws ProcessingException, IOException {
        if (wasSilent) {
            return;
        }
        if (silent) {
            session.setAttribute(__ATTRIBUTE_SILENT, (Object)"true");
        }
        State state = new State();
        session.setAttribute(STATE_SESSION_ATTRIBUTE, (Object)state);
        AuthenticationRequest authenticationRequest = new AuthenticationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), this._scope, this._clientID, redirectUri).endpointURI(this._authUri).state(state).prompt(new Prompt.Type[]{silent ? Prompt.Type.NONE : null}).build();
        String authReqURI = authenticationRequest.toURI().toString() + "&access_type=offline";
        redirector.redirect(false, authReqURI);
    }

    protected void checkState() throws AccessDeniedException {
        String stateRequest;
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession(true);
        String storedState = session.getAttribute(STATE_SESSION_ATTRIBUTE).toString();
        if (!storedState.equals(stateRequest = request.getParameter("state"))) {
            this.getLogger().error("OIDC state mismatch. Method checkState of AbstractOIDCCredentialProvider");
            throw new AccessDeniedException("OIDC state mismatch");
        }
        session.setAttribute(STATE_SESSION_ATTRIBUTE, null);
    }

    protected OIDCTokens requestToken(AuthorizationCode authCode, URI redirectUri) throws AccessDeniedException {
        TokenRequest tokenReq = new TokenRequest(this._tokenEndpointUri, this.getClientAuthentication(), (AuthorizationGrant)new AuthorizationCodeGrant(authCode, redirectUri), null);
        HTTPResponse tokenHTTPResp = null;
        try {
            tokenHTTPResp = tokenReq.toHTTPRequest().send();
        }
        catch (SerializeException | IOException e) {
            this.getLogger().error("OIDC token request failed ", e);
            throw new AccessDeniedException("OIDC token request failed");
        }
        TokenResponse tokenResponse = null;
        try {
            tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)tokenHTTPResp);
        }
        catch (ParseException e) {
            this.getLogger().error("OIDC token request result invalid ", (Throwable)e);
            throw new AccessDeniedException("OIDC token request result invalid");
        }
        if (tokenResponse instanceof TokenErrorResponse) {
            this.getLogger().error("OIDC token request invalid token response instance of TokenErrorResponse in method requestToken from AbstractOIDCCredentialProvider");
            throw new AccessDeniedException("OIDC token request result invalid");
        }
        OIDCTokenResponse accessTokenResponse = (OIDCTokenResponse)tokenResponse;
        return accessTokenResponse.getOIDCTokens();
    }

    protected OIDCTokens requestToken(ClientAuthentication clientAuth, AuthorizationGrant refreshTokenGrant) throws AccessDeniedException, URISyntaxException {
        TokenRequest tokenReq = new TokenRequest(this._tokenEndpointUri, clientAuth, refreshTokenGrant, null);
        HTTPResponse tokenHTTPResp = null;
        try {
            tokenHTTPResp = tokenReq.toHTTPRequest().send();
        }
        catch (SerializeException | IOException e) {
            this.getLogger().error("OIDC token request failed ", e);
            throw new AccessDeniedException("OIDC token request failed");
        }
        TokenResponse tokenResponse = null;
        try {
            tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)tokenHTTPResp);
        }
        catch (ParseException e) {
            this.getLogger().error("OIDC token request result invalid ", (Throwable)e);
            throw new AccessDeniedException("OIDC token request result invalid");
        }
        if (tokenResponse instanceof TokenErrorResponse) {
            this.getLogger().error("OIDC token request result invalid: tokenResponse instance of TokenErrorResponse in method requestToken from AbstractOIDCCredentialProvider");
            throw new AccessDeniedException("OIDC token request result invalid");
        }
        OIDCTokenResponse accessTokenResponse = (OIDCTokenResponse)tokenResponse;
        return accessTokenResponse.getOIDCTokens();
    }

    protected IDTokenClaimsSet validateIdToken(JWT idToken) throws AccessDeniedException {
        IDTokenClaimsSet claims;
        JWSAlgorithm jwsAlg = JWSAlgorithm.RS256;
        IDTokenValidator validator = new IDTokenValidator(this._iss, this._clientID, jwsAlg, this._jwkSetURL);
        try {
            claims = validator.validate(idToken, null);
        }
        catch (BadJOSEException e) {
            this.getLogger().error("OIDC invalid : issuer, clientId, jwsAlg or jwkSetURL", (Throwable)e);
            throw new AccessDeniedException("OIDC invalid signature issuer, clientId, jwsAlg or jwkSetURL");
        }
        catch (JOSEException e) {
            this.getLogger().error("OIDC error while validating token", (Throwable)e);
            throw new AccessDeniedException("OIDC error while validating token");
        }
        return claims;
    }

    protected UserInfo getUserInfo(AccessToken accessToken) throws IOException, ParseException {
        HTTPResponse httpResponse = new UserInfoRequest(this._userInfoEndpoint, accessToken).toHTTPRequest().send();
        UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
        if (userInfoResponse.indicatesSuccess()) {
            return userInfoResponse.toSuccessResponse().getUserInfo();
        }
        String error = userInfoResponse.toErrorResponse().getErrorObject().toJSONObject().toJSONString();
        this.getLogger().error("Failed to retrieve the user info. The server indicate the following error :\n" + error);
        throw new AccessDeniedException("Failed to retrieve the user info. The server indicate the following error :\n" + error);
    }

    protected UserIdentity getUserIdentity(UserInfo userInfo, Request request, Redirector redirector) throws NotUniqueUserException {
        String login = userInfo.getEmailAddress();
        if (login == null) {
            this.getLogger().error("Email not found, connection canceled ");
            throw new AccessDeniedException("Email not found, connection canceled");
        }
        UserPopulation userPopulation = this._getPopulation(request);
        UserIdentity user = this._getUserIdentity(login, userPopulation);
        if (user != null) {
            return user;
        }
        String firstName = userInfo.getGivenName();
        String lastName = userInfo.getFamilyName();
        if (firstName == null || lastName == null) {
            this.getLogger().info("The fields could not be pre-filled");
        }
        this._endOfAuthenticationProcess.unexistingUser(login, firstName, lastName, userPopulation, redirector, request);
        return null;
    }

    private UserIdentity _getUserIdentity(String login, UserPopulation userPopulation) throws NotUniqueUserException {
        StoredUser storedUser = null;
        for (UserDirectory userDirectory : userPopulation.getUserDirectories()) {
            storedUser = userDirectory.getStoredUser(login);
            if (storedUser == null) {
                storedUser = userDirectory.getStoredUserByEmail(login);
            }
            if (storedUser == null) continue;
            return userDirectory.getUserIdentity(storedUser);
        }
        return null;
    }
}

