/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.cas;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.jasig.cas.client.validation.TicketValidator;

/**
 * Ametys implementation of Cas20ProxyReceivingTicketValidationFilter
 */
public class AmetysCas20ProxyReceivingTicketValidationFilter extends Cas20ProxyReceivingTicketValidationFilter
{
    /** The session attribute for the proxy granting ticket */
    public static final String SESSION_ATTRIBUTE_PROXY_GRANTING_TICKET = "CasCredentialProvider:ProxyGrantingTicket";
    
    /** The ticket validator */
    protected TicketValidator _validator;
    
    @Override
    protected void initInternal(final FilterConfig filterConfig) throws ServletException
    {
        super.initInternal(filterConfig);
        
        // Workaround to get a reference to the ticket validator. As a result, org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter.getTicketValidator(FilterConfig) is called twice...
        _validator = getTicketValidator(filterConfig);
        setTicketValidator(_validator);
    }
    
    @Override
    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion)
    {
        super.onSuccessfulValidation(request, response, assertion);
        
        if (_validator instanceof AmetysCas20ProxyTicketValidator)
        {
            String proxyGrantingTicket = ((AmetysCas20ProxyTicketValidator) _validator).getProxyGrantingTicket();
            logger.debug("Ticket validation succeeded. The proxy granting ticket from Ametys Proxy Ticket Validator is: '{}'", proxyGrantingTicket);
            request.getSession().setAttribute(SESSION_ATTRIBUTE_PROXY_GRANTING_TICKET, proxyGrantingTicket);
        }
    }
}
