/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

import org.ametys.runtime.authentication.AccessDeniedException;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;

/**
 *  Sign in through Facebook, using the OpenId Connect protocol.
 */
public class FacebookCredentialProvider extends AbstractOIDCCredentialProvider
{   
    private final Scope _scopeFb = new Scope("openid", "email", "public_profile");
    
    @Override
    protected void initUrisScope() throws AccessDeniedException
    {
        try
        {
            _authUri = URI.create("https://www.facebook.com/v13.0/dialog/oauth");
            _tokenEndpointUri = URI.create("https://graph.facebook.com/v13.0/oauth/access_token");
            _iss = new Issuer("https://www.facebook.com");
            _jwkSetURL = new URI("https://www.facebook.com/.well-known/oauth/openid/jwks/").toURL();
            _userInfoEndpoint = URI.create("https://graph.facebook.com/me?fields=email,family_name,given_name,name,id");
            _scope = _scopeFb;
        }
        catch (MalformedURLException | URISyntaxException e)
        {
            getLogger().error("Encountered a problem when creating the jwkSetURL", e);
            throw new AccessDeniedException("Encountered a problem when creating the jwkSetURL");
        }
    }
}
