/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.plugins.extraction.component.ExtractionComponent;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContextHierarchyElement;
import org.ametys.plugins.thesaurus.ThesaurusDAO;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.xml.sax.ContentHandler;

public abstract class AbstractExtractionComponent
extends AbstractLogEnabled
implements ExtractionComponent,
Serviceable,
Configurable {
    protected static final String JOIN_HIERARCHY_SEPARATOR = "/";
    protected static final String JOIN_HIERARCHY_ELEMENT = "..";
    protected static final String EXTRACTION_ITEM_PATH_SEPARATOR = "\\.";
    protected List<ExtractionComponent> _subComponents = new ArrayList<ExtractionComponent>();
    protected String _tagName;
    protected ContentTypesHelper _contentTypesHelper;
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;
    protected ThesaurusDAO _thesaurusDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
        this._thesaurusDAO = (ThesaurusDAO)serviceManager.lookup(ThesaurusDAO.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._tagName = configuration.getAttribute("tagName", this.getDefaultTagName());
    }

    protected abstract String getDefaultTagName();

    @Override
    public void prepareComponentExecution(ExtractionExecutionContext context) throws Exception {
        for (ExtractionComponent subComponent : this._subComponents) {
            subComponent.prepareComponentExecution(context);
        }
    }

    @Override
    public final void execute(ContentHandler contentHandler, ExtractionExecutionContext context) throws Exception {
        long startTime = -1L;
        if (this.getLogger().isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            this.getLogger().debug(this.getLogsPrefix() + "executing component.");
        }
        this.executeComponent(contentHandler, context);
        if (this.getLogger().isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            this.getLogger().debug(this.getLogsPrefix() + "executed component in " + (endTime - startTime) + "ms");
        }
    }

    protected abstract void executeComponent(ContentHandler var1, ExtractionExecutionContext var2) throws Exception;

    public void executeSubComponents(ContentHandler contentHandler, ExtractionExecutionContext context, ExtractionExecutionContextHierarchyElement currentContextHierarchyElement) throws Exception {
        ExtractionExecutionContext newContext = new ExtractionExecutionContext(context);
        ArrayList<ExtractionExecutionContextHierarchyElement> subComponentsContextElements = new ArrayList<ExtractionExecutionContextHierarchyElement>();
        subComponentsContextElements.addAll(context.getHierarchyElements());
        subComponentsContextElements.add(currentContextHierarchyElement);
        newContext.setHierarchyElements(subComponentsContextElements);
        for (ExtractionComponent subComponent : this._subComponents) {
            subComponent.execute(contentHandler, newContext);
        }
    }

    @Override
    public void addSubComponent(ExtractionComponent subComponent) {
        this._subComponents.add(subComponent);
    }

    @Override
    public List<ExtractionComponent> getSubComponents() {
        return this._subComponents;
    }

    @Override
    public Map<String, Object> getComponentDetailsForTree() {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("text", this.getTagName());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("componentTagName", this.getTagName());
        details.put("data", data);
        return details;
    }

    protected abstract String getLogsPrefix();

    public String getTagName() {
        return this._tagName;
    }

    public void setTagName(String tagName) {
        this._tagName = tagName;
    }
}

