/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.component;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.type.ModelItemTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.GetQueryFromJSONHelper;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.model.SearchModel;
import org.ametys.cms.search.model.SearchModelHelper;
import org.ametys.cms.search.model.SystemProperty;
import org.ametys.cms.search.model.SystemPropertyExtensionPoint;
import org.ametys.cms.search.query.QuerySyntaxException;
import org.ametys.cms.search.solr.SolrContentQueryHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.extraction.component.AbstractExtractionComponent;
import org.ametys.plugins.extraction.component.ExtractionClause;
import org.ametys.plugins.extraction.component.ExtractionClauseGroup;
import org.ametys.plugins.extraction.component.ExtractionComponent;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContextHierarchyElement;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.EmptyIterable;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.xml.sax.ContentHandler;

public abstract class AbstractSolrExtractionComponent
extends AbstractExtractionComponent {
    private static final String __EXTRACT_VARIABLES_REGEX = "\\$\\{([^{}]+)\\}";
    private static final String __CHECK_JOIN_VARIABLES_REGEX = "\\.\\.(?:\\/\\.\\.)*(?:\\/[^\\/}]+)?";
    protected Set<String> _contentTypes = new HashSet<String>();
    protected String _queryReferenceId;
    protected List<ExtractionClause> _clauses = new ArrayList<ExtractionClause>();
    protected GetQueryFromJSONHelper _getQueryFromJSONHelper;
    protected JSONUtils _jsonUtils;
    private AmetysObjectResolver _resolver;
    private SystemPropertyExtensionPoint _systemPropertyExtensionPoint;
    private ContentHelper _contentHelper;
    private ContentSearcherFactory _contentSearcherFactory;
    private SearchModelHelper _searchModelHelper;
    private ModelItemTypeExtensionPoint _contentAttributeTypeExtensionPoint;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._getQueryFromJSONHelper = (GetQueryFromJSONHelper)serviceManager.lookup(GetQueryFromJSONHelper.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._systemPropertyExtensionPoint = (SystemPropertyExtensionPoint)serviceManager.lookup(SystemPropertyExtensionPoint.ROLE);
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
        this._contentSearcherFactory = (ContentSearcherFactory)serviceManager.lookup(ContentSearcherFactory.ROLE);
        this._searchModelHelper = (SearchModelHelper)serviceManager.lookup(SearchModelHelper.ROLE);
        this._contentAttributeTypeExtensionPoint = (ModelItemTypeExtensionPoint)serviceManager.lookup(ModelItemTypeExtensionPoint.ROLE_CONTENT_ATTRIBUTE);
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        Configuration clauses = configuration.getChild("clauses");
        for (Configuration clause : clauses.getChildren("clause")) {
            this.addClauses(clause.getValue());
        }
        this._contentTypes = new HashSet<String>();
        if (Arrays.asList(configuration.getAttributeNames()).contains("ref")) {
            if (Arrays.asList(configuration.getAttributeNames()).contains("contentTypes")) {
                throw new IllegalArgumentException(this.getLogsPrefix() + "a component with a query reference should not specify a content type");
            }
            this._queryReferenceId = configuration.getAttribute("ref");
        } else {
            String contentTypesString = configuration.getAttribute("contentTypes");
            this._contentTypes.addAll(StringUtils.stringToCollection((String)contentTypesString));
        }
    }

    @Override
    public void prepareComponentExecution(ExtractionExecutionContext context) throws Exception {
        super.prepareComponentExecution(context);
        if (this._queryReferenceId != null && !this._queryReferenceId.isEmpty()) {
            Query referencedQuery = (Query)this._resolver.resolveById(this._queryReferenceId);
            this.computeReferencedQueryInfos(referencedQuery.getContent());
        }
        this._computeClausesInfos(context);
    }

    protected void computeReferencedQueryInfos(String refQueryContent) throws QuerySyntaxException {
        String q;
        Map contentMap = this._jsonUtils.convertJsonToMap(refQueryContent);
        Map exportParams = (Map)contentMap.get("exportParams");
        String modelId = (String)exportParams.get("model");
        if (modelId.contains("solr")) {
            Map values = (Map)exportParams.get("values");
            String baseQuery = (String)values.get("query");
            this._contentTypes = new HashSet<String>((List)values.get("contentTypes"));
            q = SolrContentQueryHelper.buildQuery((SearchModelHelper)this._searchModelHelper, (String)baseQuery, this._contentTypes, Collections.emptySet());
        } else {
            SearchModel model = this._getQueryFromJSONHelper.getSearchModel(exportParams);
            ArrayList contentTypesToFill = new ArrayList();
            org.ametys.cms.search.query.Query query = this._getQueryFromJSONHelper.getQueryFromModel(model, exportParams, contentTypesToFill);
            q = query.build();
            this._contentTypes = new HashSet<String>(contentTypesToFill);
        }
        ExtractionClause clause = new ExtractionClause();
        clause.setExpression(q);
        this._clauses.add(0, clause);
    }

    private void _computeClausesInfos(ExtractionExecutionContext context) {
        for (ExtractionClause clause : this._clauses) {
            String clauseExpression = clause.getExpression();
            clause.setExpression(clauseExpression);
            List<ExtractionClauseGroup> groups = this._extractGroupExpressionsFromClause(clauseExpression);
            if (!groups.isEmpty()) {
                Collection groupExpressions = groups.stream().map(ExtractionClauseGroup::getCompleteExpression).collect(Collectors.toList());
                if (this._hasVariablesOutsideGroups(clauseExpression, groupExpressions, context.getClausesVariablesValues().keySet())) {
                    throw new IllegalArgumentException(this.getLogsPrefix() + "if there's at least one group, every variable should be in a group.");
                }
            } else {
                ExtractionClauseGroup group = new ExtractionClauseGroup();
                group.setCompleteExpression(clauseExpression);
                group.setExpression(clauseExpression);
                groups.add(group);
            }
            for (ExtractionClauseGroup group : groups) {
                HashSet<String> variables = new HashSet<String>(this._extractVariablesFromClauseExpression(group.getExpression(), context.getClausesVariablesValues().keySet()));
                if (!variables.isEmpty()) {
                    if (variables.size() > 1) {
                        throw new IllegalArgumentException(this.getLogsPrefix() + "only variables with same name are allowed within a single group");
                    }
                    for (String variable : variables) {
                        String[] pathSegments = variable.split("/");
                        String fieldPath = pathSegments[pathSegments.length - 1];
                        group.setVariable(variable);
                        group.setFieldPath(fieldPath);
                    }
                }
                clause.addGroup(group);
            }
        }
    }

    private boolean _hasVariablesOutsideGroups(String clauseExpression, Collection<String> groupExpressions, Collection<Extraction.ClausesVariable> clausesVariable) {
        List<String> variablesInClause = this._extractVariablesFromClauseExpression(clauseExpression, clausesVariable);
        ArrayList<String> variablesInGroups = new ArrayList<String>();
        for (String groupExpression : groupExpressions) {
            variablesInGroups.addAll(this._extractVariablesFromClauseExpression(groupExpression, clausesVariable));
        }
        return variablesInClause.size() > variablesInGroups.size();
    }

    List<ExtractionClauseGroup> _extractGroupExpressionsFromClause(String expression) {
        ArrayList<ExtractionClauseGroup> groupExpressions = new ArrayList<ExtractionClauseGroup>();
        int indexOfGroup = expression.indexOf("#{");
        while (indexOfGroup != -1) {
            StringBuilder currentGroupSb = new StringBuilder();
            int endIndex = indexOfGroup;
            int braceLevel = 0;
            for (int i = indexOfGroup + 2; i < expression.length(); ++i) {
                endIndex = i;
                char currentChar = expression.charAt(i);
                if ('{' == currentChar) {
                    ++braceLevel;
                } else if ('}' == currentChar) {
                    if (0 == braceLevel) {
                        ExtractionClauseGroup group = new ExtractionClauseGroup();
                        String currentGroup = currentGroupSb.toString();
                        group.setCompleteExpression("#{" + currentGroup + "}");
                        group.setExpression(currentGroup);
                        groupExpressions.add(group);
                        break;
                    }
                    --braceLevel;
                }
                currentGroupSb.append(currentChar);
            }
            indexOfGroup = expression.indexOf("#{", endIndex);
        }
        return groupExpressions;
    }

    List<String> _extractVariablesFromClauseExpression(String expression, Collection<Extraction.ClausesVariable> clausesVariable) {
        ArrayList<String> variableNames = new ArrayList<String>();
        Pattern variablePattern = Pattern.compile(__EXTRACT_VARIABLES_REGEX);
        Matcher variableMatcher = variablePattern.matcher(expression);
        while (variableMatcher.find()) {
            String variableName = variableMatcher.group(1);
            Pattern joinPattern = Pattern.compile(__CHECK_JOIN_VARIABLES_REGEX);
            Matcher joinMatcher = joinPattern.matcher(variableName);
            if (!clausesVariable.stream().map(var -> var.name()).anyMatch(variableName::equals) && !joinMatcher.matches()) continue;
            variableNames.add(variableName);
        }
        return variableNames;
    }

    @Override
    public void executeComponent(ContentHandler contentHandler, ExtractionExecutionContext context) throws Exception {
        Iterable<Content> contents = this.getContents(context);
        this.processContents(contents, contentHandler, context);
    }

    List<String> _getClauseQueries(ExtractionExecutionContext context) {
        ArrayList<String> clauseQueries = new ArrayList<String>();
        for (ExtractionClause clause : this._clauses) {
            String expression = clause.getExpression();
            for (ExtractionClauseGroup group : clause.getGroups()) {
                String variableName = group.getVariable();
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)variableName)) continue;
                ArrayList<CallSite> groupExpressions = new ArrayList<CallSite>();
                if (context.getClausesVariablesValues().keySet().stream().anyMatch(clausesVariable -> clausesVariable.name().equals(variableName))) {
                    Map.Entry clausesVariableValues = context.getClausesVariablesValues().entrySet().stream().filter(entry -> ((Extraction.ClausesVariable)entry.getKey()).name().equals(variableName)).findFirst().get();
                    if (Extraction.ClausesVariableType.SELECT_CONTENTS.equals((Object)((Extraction.ClausesVariable)clausesVariableValues.getKey()).type())) {
                        String attributeTypeId = "content";
                        Collection values = ((List)clausesVariableValues.getValue()).stream().map(Object.class::cast).collect(Collectors.toList());
                        for (Object value : values) {
                            String valueAsString = this._getValueAsString(value, attributeTypeId, group.getFieldPath());
                            groupExpressions.add((CallSite)((Object)("(" + group.getExpression().replace("${" + variableName + "}", valueAsString) + ")")));
                        }
                    } else {
                        List solrRequests = (List)clausesVariableValues.getValue();
                        if (solrRequests.size() == 1) {
                            groupExpressions.add((CallSite)((Object)("(" + group.getExpression().replace("${" + variableName + "}", (CharSequence)solrRequests.get(0)) + ")")));
                        }
                    }
                } else {
                    ExtractionExecutionContextHierarchyElement currentContextHierarchyElement = this._getCurrentContextElementFromVariable(variableName, context.getHierarchyElements());
                    ExtractionComponent contextComponent = currentContextHierarchyElement.getComponent();
                    String attributeTypeId = this._getAttributeTypeId(group.getFieldPath(), contextComponent.getContentTypes());
                    Collection<Object> values = this._getValuesFromVariable(group.getFieldPath(), attributeTypeId, currentContextHierarchyElement, context.getDefaultLocale());
                    for (Object value : values) {
                        String valueAsString = this._getValueAsString(value, attributeTypeId, group.getFieldPath());
                        groupExpressions.add((CallSite)((Object)("(" + group.getExpression().replace("${" + variableName + "}", valueAsString) + ")")));
                    }
                }
                if (groupExpressions.isEmpty()) {
                    this.getLogger().warn(this.getLogsPrefix() + "no value found for field '" + group.getFieldPath() + "'. The query of this component can't be achieved");
                    return null;
                }
                String groupReplacement = org.apache.commons.lang3.StringUtils.join(groupExpressions, (String)" OR ");
                expression = expression.replace(group.getCompleteExpression(), "(" + groupReplacement + ")");
            }
            clauseQueries.add(expression);
        }
        return clauseQueries;
    }

    private ExtractionExecutionContextHierarchyElement _getCurrentContextElementFromVariable(String variable, List<ExtractionExecutionContextHierarchyElement> context) {
        int lastIndexOfSlash = variable.lastIndexOf("/");
        int indexOfCurrentContext = -1;
        if (lastIndexOfSlash == -1) {
            indexOfCurrentContext = context.size() - 1;
        } else {
            int hierarchicalLevel = (lastIndexOfSlash + 1) / 3;
            indexOfCurrentContext = context.size() - hierarchicalLevel;
            if (variable.endsWith("..")) {
                --indexOfCurrentContext;
            }
        }
        if (indexOfCurrentContext < 0 || indexOfCurrentContext >= context.size()) {
            throw new IllegalArgumentException(this.getLogsPrefix() + "join on '" + variable + "' does not refer to an existing parent");
        }
        return context.get(indexOfCurrentContext);
    }

    protected String _getAttributeTypeId(String fieldPath, Collection<String> contentTypeIds) {
        if ("..".equals(fieldPath)) {
            return "content";
        }
        String[] pathSegments = fieldPath.split("\\.");
        String propertyName = pathSegments[pathSegments.length - 1];
        if (this._systemPropertyExtensionPoint.hasExtension(propertyName)) {
            SystemProperty systemProperty = (SystemProperty)this._systemPropertyExtensionPoint.getExtension(propertyName);
            return systemProperty.getType().getId();
        }
        String fieldPathWthClassicSeparator = fieldPath.replaceAll("\\.", "/");
        Collection contentTypes = contentTypeIds.stream().map(arg_0 -> ((ContentTypeExtensionPoint)this._contentTypeExtensionPoint).getExtension(arg_0)).collect(Collectors.toList());
        if (ModelHelper.hasModelItem((String)fieldPathWthClassicSeparator, (Collection)contentTypes)) {
            ModelItem modelItem = ModelHelper.getModelItem((String)fieldPathWthClassicSeparator, (Collection)contentTypes);
            return modelItem.getType().getId();
        }
        throw new IllegalArgumentException(this.getLogsPrefix() + "join on '" + fieldPath + "'. This attribute is not available");
    }

    private Collection<Object> _getValuesFromVariable(String fieldPath, String attributeTypeId, ExtractionExecutionContextHierarchyElement contextHierarchyElement, Locale defaultLocale) {
        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
        Iterable<Content> contents = contextHierarchyElement.getContents();
        for (Content content : contents) {
            boolean isAutoposting = contextHierarchyElement.isAutoposting();
            Collection<Object> contentValues = this._getContentValuesFromVariable(content, fieldPath, attributeTypeId, isAutoposting, defaultLocale);
            values.addAll(contentValues);
        }
        return values;
    }

    private Collection<Object> _getContentValuesFromVariable(Content content, String fieldPath, String attributeTypeId, boolean isAutoposting, Locale defaultLocale) {
        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
        Object value = this._getContentValue(content, fieldPath);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(values);
        if (isAutoposting && "content".equals(attributeTypeId)) {
            for (Object e : values) {
                Optional<Content> parent = e instanceof ContentValue ? ((ContentValue)e).getContentIfExists() : Optional.of((Content)e);
                ContentType contentType = parent.map(arg_0 -> ((ContentTypesHelper)this._contentTypesHelper).getFirstContentType(arg_0)).orElse(null);
                if (contentType == null || !Arrays.asList((String[])this._contentTypesHelper.getSupertypeIds(contentType.getId()).getLeft()).contains("org.ametys.plugins.thesaurus.Content.term")) continue;
                AmetysObjectIterable chidren = this._thesaurusDAO.getChildTerms(contentType.getId(), parent.get().getId());
                for (Content child : chidren) {
                    Collection<Object> childValues = this._getContentValuesFromVariable(child, "..", attributeTypeId, isAutoposting, defaultLocale);
                    result.addAll(childValues);
                }
            }
        }
        return result;
    }

    private Object _getContentValue(Content content, String fieldPath) {
        if ("..".equals(fieldPath)) {
            return content;
        }
        String fieldPathWthClassicSeparator = fieldPath.replaceAll("\\.", "/");
        return this._contentHelper.getValue(content, fieldPathWthClassicSeparator);
    }

    private <T> String _getValueAsString(Object value, String attributeTypeId, String fieldPath) {
        ModelItemType modelItemType = (ModelItemType)this._contentAttributeTypeExtensionPoint.getExtension(attributeTypeId);
        if (modelItemType instanceof ElementType) {
            ElementType elementType = (ElementType)modelItemType;
            Object typedValue = elementType.castValue(value);
            String valueAsString = elementType.toString(typedValue);
            return ClientUtils.escapeQueryChars((String)valueAsString);
        }
        throw new IllegalArgumentException(this.getLogsPrefix() + "join on '" + fieldPath + "'. Attribute type '" + attributeTypeId + "' is not supported by extraction module");
    }

    protected ContentSearcherFactory.SimpleContentSearcher getContentSearcher() {
        return this._contentSearcherFactory.create(this._contentTypes);
    }

    protected Iterable<Content> getContents(ExtractionExecutionContext context) throws Exception {
        List<String> clauseQueries = this._getClauseQueries(context);
        if (clauseQueries == null) {
            return new EmptyIterable();
        }
        List filterQueryStrings = clauseQueries.stream().map(LambdaUtils.wrap(clauseQuery -> SolrContentQueryHelper.buildQuery((SearchModelHelper)this._searchModelHelper, (String)clauseQuery, Collections.emptySet(), Collections.emptySet()))).collect(Collectors.toList());
        return this.getContentSearcher().withFilterQueryStrings(filterQueryStrings).setCheckRights(false).search("*:*");
    }

    protected abstract void processContents(Iterable<Content> var1, ContentHandler var2, ExtractionExecutionContext var3) throws Exception;

    @Override
    public Map<String, Object> getComponentDetailsForTree() {
        Map<String, Object> details = super.getComponentDetailsForTree();
        Map data = (Map)details.get("data");
        ArrayList<String> clauses = new ArrayList<String>();
        for (ExtractionClause clause : this.getClauses()) {
            clauses.add(clause.getExpression());
        }
        data.put("clauses", clauses);
        data.put("useQueryRef", org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this._queryReferenceId));
        data.put("contentTypes", this.getContentTypes());
        data.put("queryReferenceId", this.getQueryReferenceId());
        return details;
    }

    @Override
    public Set<String> getContentTypes() {
        return this._contentTypes;
    }

    public void addContentTypes(String ... contentTypes) {
        this._contentTypes.addAll(Arrays.asList(contentTypes));
    }

    public String getQueryReferenceId() {
        return this._queryReferenceId;
    }

    public void setQueryReferenceId(String queryReferenceId) {
        this._queryReferenceId = queryReferenceId;
    }

    public List<ExtractionClause> getClauses() {
        return this._clauses;
    }

    public void addClauses(String ... expressions) {
        for (String expression : expressions) {
            ExtractionClause clause = new ExtractionClause();
            clause.setExpression(expression);
            this._clauses.add(clause);
        }
    }
}

