/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.component;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.extraction.component.AbstractExtractionComponent;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContextHierarchyElement;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.thesaurus.Thesaurus;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class ThesaurusExtractionComponent
extends AbstractExtractionComponent {
    private String _microThesaurusId;
    private Thesaurus _thesaurus;
    private ContentType _microThesaurus;
    private int _maxLevel;
    private I18nUtils _i18nUtils;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
    }

    @Override
    public void configure(Configuration thesaurus) throws ConfigurationException {
        super.configure(thesaurus);
        this._microThesaurusId = thesaurus.getAttribute("microThesaurus");
        this._maxLevel = thesaurus.getAttributeAsInteger("max-level", -1);
        Set ancestors = this._contentTypesHelper.getAncestors(this._microThesaurusId);
        if (!ancestors.contains("org.ametys.plugins.thesaurus.Content.term")) {
            throw new IllegalArgumentException(this.getLogsPrefix() + "'" + this._microThesaurusId + "' is not a valid microthesaurus id");
        }
        this._initializeThesaurus();
    }

    void _initializeThesaurus() {
        this._microThesaurus = (ContentType)this._contentTypeExtensionPoint.getExtension(this._microThesaurusId);
        this._thesaurus = this._thesaurusDAO.getParentThesaurus(this._microThesaurus);
        if (this._thesaurus == null) {
            throw new IllegalArgumentException(this.getLogsPrefix() + "The microthesaurus '" + this._microThesaurusId + "' has no attached thesaurus.");
        }
    }

    @Override
    public void executeComponent(ContentHandler contentHandler, ExtractionExecutionContext context) throws Exception {
        I18nizableText i18nLabel = this._microThesaurus.getLabel();
        String label = this._i18nUtils.translate((I18nizable)i18nLabel, null);
        AttributesImpl thesaurusAttributes = new AttributesImpl();
        thesaurusAttributes.addCDATAAttribute("thesaurusLabel", this._thesaurus.getLabel());
        thesaurusAttributes.addCDATAAttribute("microThesaurusLabel", label);
        thesaurusAttributes.addCDATAAttribute("microThesaurusId", this._microThesaurusId);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)this._tagName, (Attributes)thesaurusAttributes);
        AmetysObjectIterable children = this._thesaurusDAO.getRootTerms(this._microThesaurusId);
        this._processChildren(contentHandler, (AmetysObjectIterable<Content>)children, 1, context);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)this._tagName);
    }

    @Override
    public Set<String> getContentTypes() {
        return new HashSet<String>(Collections.singletonList(this._microThesaurusId));
    }

    private void _processChildren(ContentHandler contentHandler, AmetysObjectIterable<Content> children, int currentLevel, ExtractionExecutionContext context) throws Exception {
        long nbTermChildren = -1L;
        int currentChildIndex = 0;
        if (this.getLogger().isDebugEnabled()) {
            nbTermChildren = children.getSize();
        }
        for (Content term : children) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.getLogsPrefix() + "executing term " + ++currentChildIndex + "/" + nbTermChildren + " at level " + currentLevel);
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addCDATAAttribute("name", term.getTitle());
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"term", (Attributes)attributes);
            if (this._maxLevel < 0 || currentLevel < this._maxLevel) {
                currentContext = new ExtractionExecutionContextHierarchyElement(this, Collections.singleton(term), false);
                this.executeSubComponents(contentHandler, context, currentContext);
                this._processChildren(contentHandler, (AmetysObjectIterable<Content>)this._thesaurusDAO.getChildTerms(this._microThesaurusId, term.getId()), currentLevel + 1, context);
            } else {
                currentContext = new ExtractionExecutionContextHierarchyElement(this, Collections.singleton(term));
                this.executeSubComponents(contentHandler, context, currentContext);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"term");
        }
    }

    @Override
    public Map<String, Object> getComponentDetailsForTree() {
        Map<String, Object> details = super.getComponentDetailsForTree();
        details.put("tag", "thesaurus");
        Map data = (Map)details.get("data");
        data.put("thesaurusId", this._thesaurus.getId());
        data.put("microThesaurusId", this.getMicroThesaurusId());
        data.put("maxLevel", this.getMaxLevel());
        details.put("iconCls", "ametysicon-books");
        return details;
    }

    @Override
    protected String getDefaultTagName() {
        return "thesaurus";
    }

    @Override
    protected String getLogsPrefix() {
        return "Thesaurus component '" + this._tagName + "': ";
    }

    public String getMicroThesaurusId() {
        return this._microThesaurusId;
    }

    public void setMicroThesaurusId(String microThesaurusId) {
        this._microThesaurusId = microThesaurusId;
    }

    public int getMaxLevel() {
        return this._maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this._maxLevel = maxLevel;
    }
}

