/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.commons.io.FileUtils;

public class DeleteExtractionResultFilesClientSideElement
extends StaticClientSideElement {
    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> deleteResults(List<String> paths) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> deleted = new ArrayList<String>();
        ArrayList<String> notDeleted = new ArrayList<String>();
        ArrayList<String> doNotExist = new ArrayList<String>();
        Path rootResults = AmetysHomeHelper.getAmetysHomeData().toPath().resolve("extraction");
        for (String path : paths) {
            DeleteExtractionResultFilesClientSideElement._tryToDelete(path, rootResults, deleted, notDeleted, doNotExist);
        }
        result.put("deleted", deleted);
        result.put("errors", notDeleted);
        result.put("not-exist", doNotExist);
        return result;
    }

    private static void _tryToDelete(String path, Path rootResults, List<String> deleted, List<String> notDeleted, List<String> doNotExist) {
        Path fileOrFolder = rootResults.resolve(Paths.get(path, new String[0]));
        if (Files.exists(fileOrFolder, new LinkOption[0])) {
            try {
                DeleteExtractionResultFilesClientSideElement._delete(fileOrFolder);
                deleted.add(path);
            }
            catch (IOException e) {
                notDeleted.add(path);
            }
        } else {
            doNotExist.add(path);
        }
    }

    private static void _delete(Path fileOrFolder) throws IOException {
        if (Files.isDirectory(fileOrFolder, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)fileOrFolder.toFile());
        } else {
            Files.delete(fileOrFolder);
        }
    }
}

