/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.extraction.component.ExtractionComponent;

public class Extraction {
    private String _fileName;
    private String _descriptionId;
    private List<ExtractionComponent> _extractionComponents;
    private List<String> _displayOptionalColumnsNames;
    private List<ClausesVariable> _clausesVariables;
    private UserIdentity _author;

    public Extraction(String fileName) {
        this._fileName = fileName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getDescriptionId() {
        return this._descriptionId;
    }

    public void setDescriptionId(String descriptionId) {
        this._descriptionId = descriptionId;
    }

    public List<ExtractionComponent> getExtractionComponents() {
        return null != this._extractionComponents ? this._extractionComponents : new ArrayList<ExtractionComponent>();
    }

    public void addExtractionComponent(ExtractionComponent extractionComponent) {
        if (null == this._extractionComponents) {
            this._extractionComponents = new ArrayList<ExtractionComponent>();
        }
        this._extractionComponents.add(extractionComponent);
    }

    public List<String> getDisplayOptionalColumnsNames() {
        return null != this._displayOptionalColumnsNames ? this._displayOptionalColumnsNames : new ArrayList<String>();
    }

    public void setDisplayOptionalColumnsNames(List<String> displayOptionalColumnsNames) {
        this._displayOptionalColumnsNames = displayOptionalColumnsNames;
    }

    public List<ClausesVariable> getClausesVariables() {
        return null != this._clausesVariables ? this._clausesVariables : new ArrayList<ClausesVariable>();
    }

    public void setClausesVariables(List<ClausesVariable> clausesVariables) {
        this._clausesVariables = clausesVariables;
    }

    public UserIdentity getAuthor() {
        return this._author;
    }

    public void setAuthor(UserIdentity author) {
        this._author = author;
    }

    public record ClausesVariable(String name, ClausesVariableType type, List<String> contentTypeIds, Optional<String> searchModelId, Optional<String> solrRequest) {
    }

    public static enum ClausesVariableType {
        SOLR_REQUEST("solrRequest"),
        SELECT_CONTENTS("selectContents");

        private final String _stringValue;

        private ClausesVariableType(String stringValue) {
            this._stringValue = stringValue;
        }

        public String getStringValue() {
            return this._stringValue;
        }

        public static ClausesVariableType fromStringValue(String stringValue) throws IllegalArgumentException {
            for (ClausesVariableType type : ClausesVariableType.values()) {
                if (!type.getStringValue().equals(stringValue)) continue;
                return type;
            }
            throw new IllegalArgumentException("'" + stringValue + "' is not an available type of clauses variable");
        }
    }

    public static enum ExtractionProfile {
        READ_ACCESS,
        WRITE_ACCESS,
        RIGHT_ACCESS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

