/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import com.google.common.base.Predicates;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.extraction.component.ExtractionComponent;
import org.ametys.plugins.extraction.component.TwoStepsExecutingExtractionComponent;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.extraction.execution.ExtractionDefinitionReader;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;
import org.ametys.plugins.extraction.execution.PathResolver;
import org.ametys.plugins.extraction.execution.pipeline.Pipeline;
import org.ametys.plugins.extraction.execution.pipeline.PipelineDescriptor;
import org.ametys.plugins.extraction.execution.pipeline.Pipelines;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class ExtractionExecutor
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ExtractionExecutor.class.getName();
    private RightManager _rightManager;
    private ExtractionDefinitionReader _reader;
    private CurrentUserProvider _currentUserProvider;
    private AmetysObjectResolver _resolver;
    private ContentTypesHelper _contentTypesHelper;
    private SourceResolver _sourceResolver;
    private PathResolver _resultPathResolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._reader = (ExtractionDefinitionReader)((Object)serviceManager.lookup(ExtractionDefinitionReader.ROLE));
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._resultPathResolver = (PathResolver)((Object)serviceManager.lookup(PathResolver.ROLE));
    }

    public Set<Path> execute(String relativeFilePath, String defaultResultFileName, String lang, Map<String, Object> parameters, PipelineDescriptor pipeline) throws Exception {
        return this._execute(relativeFilePath, defaultResultFileName, null, lang, parameters, pipeline);
    }

    public void execute(String relativeFilePath, OutputStream resultOutputStream, String lang, Map<String, Object> parameters, PipelineDescriptor pipeline) throws Exception {
        this._execute(relativeFilePath, null, resultOutputStream, lang, parameters, pipeline);
    }

    private Set<Path> _execute(String relativeFilePath, String defaultResultFileName, OutputStream resultOutputStream, String lang, Map<String, Object> parameters, PipelineDescriptor pipeline) throws Exception {
        this._checkRights();
        Pair<Extraction, String> extractionAndName = this._getExtraction(relativeFilePath);
        Extraction extraction = (Extraction)extractionAndName.getLeft();
        String definitionFilename = (String)extractionAndName.getRight();
        AttributesImpl attributes = this._getAttrs(definitionFilename);
        ExtractionExecutionContext context = this._getContext(extraction, lang, parameters);
        if (resultOutputStream != null) {
            this._doExecuteForPathWithNoVar(attributes, extraction, context, resultOutputStream, pipeline);
            return Set.of();
        }
        return this._doExecute(attributes, extraction, relativeFilePath, context, defaultResultFileName, pipeline);
    }

    private void _checkRights() {
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Extraction_Rights_ExecuteExtraction", (Object)"/admin") != RightManager.RightResult.RIGHT_ALLOW) {
            String errorMessage = "User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to execute extraction with no sufficient rights";
            this.getLogger().error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    private Pair<Extraction, String> _getExtraction(String relativeFilePath) throws Exception {
        String absoluteFilePath = "context://WEB-INF/param/extraction/definitions/" + relativeFilePath;
        Source src = this._sourceResolver.resolveURI(absoluteFilePath);
        try {
            File file = ((FileSource)src).getFile();
            if (!file.exists()) {
                throw new IllegalArgumentException("The file " + relativeFilePath + " does not exist.");
            }
            Extraction extraction = this._reader.readExtractionDefinitionFile(file);
            Pair pair = Pair.of((Object)extraction, (Object)file.getName());
            return pair;
        }
        catch (Exception e) {
            throw new IllegalStateException("An unexpected error occured.", e);
        }
        finally {
            this._sourceResolver.release(src);
        }
    }

    private AttributesImpl _getAttrs(String definitionFilename) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addCDATAAttribute("user", this._currentUserProvider.getUser().getLogin());
        attributes.addCDATAAttribute("date", ZonedDateTime.now().format(DateUtils.getISODateTimeFormatter()));
        attributes.addCDATAAttribute("name", definitionFilename);
        return attributes;
    }

    private ExtractionExecutionContext _getContext(Extraction extraction, String lang, Map<String, Object> parameters) {
        ExtractionExecutionContext context = new ExtractionExecutionContext();
        if (StringUtils.isNotEmpty((CharSequence)lang)) {
            context.setDefaultLocale(LocaleUtils.toLocale((String)lang));
        }
        context.setDisplayOptionalColumns(this._getDisplayOptionalColumns(extraction.getDisplayOptionalColumnsNames(), parameters));
        context.setClausesVariablesValues(this._getClausesVariablesValues(extraction.getClausesVariables(), parameters));
        return context;
    }

    Map<String, Boolean> _getDisplayOptionalColumns(List<String> displayOptionalColumnsNames, Map<String, Object> parameters) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String name : displayOptionalColumnsNames) {
            Boolean value = this._getDipslayOptionalColumn(name, parameters);
            if (value == null) {
                throw new IllegalArgumentException("Extraction - There is a variable named '" + name + "' but there is no corresponding value");
            }
            result.put(name, value);
        }
        return result;
    }

    private Boolean _getDipslayOptionalColumn(String optionalColumnName, Map<String, Object> parameters) {
        Object value = parameters.get(optionalColumnName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return null;
    }

    private Map<Extraction.ClausesVariable, List<String>> _getClausesVariablesValues(List<Extraction.ClausesVariable> clausesVariables, Map<String, Object> parameters) {
        HashMap<Extraction.ClausesVariable, List<String>> result = new HashMap<Extraction.ClausesVariable, List<String>>();
        for (Extraction.ClausesVariable clausesVariable : clausesVariables) {
            if (Extraction.ClausesVariableType.SELECT_CONTENTS.equals((Object)clausesVariable.type())) {
                Optional contentTypeId = clausesVariable.contentTypeIds().stream().findFirst();
                List contentIds = (List)parameters.get(clausesVariable.name());
                if (contentIds == null || contentIds.isEmpty()) {
                    throw new IllegalArgumentException("Extraction - There is a variable named '" + clausesVariable.name() + "' but there is no corresponding value");
                }
                if (contentTypeId.isPresent()) {
                    for (String contentId : contentIds) {
                        Content content = (Content)this._resolver.resolveById(contentId);
                        if (this._contentTypesHelper.isInstanceOf(content, (String)contentTypeId.get())) continue;
                        throw new IllegalArgumentException("Extraction - content '" + contentId + "' is not an instance of content type '" + (String)contentTypeId.get() + "', defined by the variable named '" + clausesVariable.name() + "'");
                    }
                }
                result.put(clausesVariable, contentIds);
                continue;
            }
            String solrRequest = (String)parameters.get(clausesVariable.name());
            if (StringUtils.isEmpty((CharSequence)solrRequest)) {
                throw new IllegalArgumentException("Extraction - There is a variable named '" + clausesVariable.name() + "' but there is no corresponding value");
            }
            result.put(clausesVariable, List.of(solrRequest));
        }
        return result;
    }

    private Set<Path> _doExecute(AttributesImpl attributes, Extraction extraction, String extractionFilePath, ExtractionExecutionContext context, String defaultResultFileName, PipelineDescriptor pipeline) throws Exception {
        String unresolvedPath = pipeline.getResultSubfolder();
        Path basePath = Paths.get(AmetysHomeHelper.getAmetysHomeData().toPath().toString(), "extraction");
        if (this._resultPathResolver.hasVariable(unresolvedPath)) {
            List<ExtractionComponent> extractionComponents = extraction.getExtractionComponents();
            boolean allAreNotTwoStepsComponent = extractionComponents.stream().filter(Predicates.not(TwoStepsExecutingExtractionComponent.class::isInstance)).findFirst().isPresent();
            if (allAreNotTwoStepsComponent) {
                throw new IllegalArgumentException("The extraction " + extractionFilePath + " has an invalid component at first level which does not support a subfolder containing variables.");
            }
            List<TwoStepsExecutingExtractionComponent> components = extractionComponents.stream().map(TwoStepsExecutingExtractionComponent.class::cast).collect(Collectors.toList());
            return this._doExecuteForPathWithVar(attributes, extraction, context, components, basePath, unresolvedPath, pipeline);
        }
        Path fileOrFolderPath = this._resultPathResolver.resolvePath(unresolvedPath, null, extraction, basePath).keySet().iterator().next();
        Path filePath = this._filePathWhenNoVar(fileOrFolderPath, defaultResultFileName);
        try (OutputStream fileOs = Pipelines.getOutputStream(filePath);){
            this._doExecuteForPathWithNoVar(attributes, extraction, context, fileOs, pipeline);
            Set<Path> set = Set.of(filePath);
            return set;
        }
    }

    private Path _filePathWhenNoVar(Path fileOrFolderPath, String defaultFileName) {
        Path fileName = fileOrFolderPath.getFileName();
        if (fileName.toString().contains(".")) {
            return fileOrFolderPath;
        }
        return Paths.get(fileOrFolderPath.toString(), defaultFileName);
    }

    private void _doExecuteForPathWithNoVar(AttributesImpl attributes, Extraction extraction, ExtractionExecutionContext context, OutputStream outputStream, PipelineDescriptor pipelineDescriptor) throws Exception {
        try (Pipeline pipeline = pipelineDescriptor.newPipeline(outputStream);){
            ContentHandler contentHandler = pipeline.getHandler();
            this._noVarExecute(contentHandler, attributes, extraction, context);
            pipeline.serialize();
        }
    }

    private void _noVarExecute(ContentHandler contentHandler, AttributesImpl attributes, Extraction extraction, ExtractionExecutionContext context) throws Exception {
        contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"extraction", (Attributes)attributes);
        for (ExtractionComponent component : extraction.getExtractionComponents()) {
            component.prepareComponentExecution(context);
            component.execute(contentHandler, context);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"extraction");
        contentHandler.endDocument();
    }

    private Set<Path> _doExecuteForPathWithVar(AttributesImpl attributes, Extraction extraction, ExtractionExecutionContext context, List<TwoStepsExecutingExtractionComponent> components, Path basePath, String unresolvedPath, PipelineDescriptor pipelineDescriptor) throws Exception {
        HashMap<TwoStepsExecutingExtractionComponent, List<Content>> firstLevelResultsByComponent = new HashMap<TwoStepsExecutingExtractionComponent, List<Content>>();
        for (TwoStepsExecutingExtractionComponent component : components) {
            component.prepareComponentExecution(context);
            List firstLevelResults = StreamSupport.stream(component.computeFirstLevelResults(context).spliterator(), false).collect(Collectors.toList());
            firstLevelResultsByComponent.put(component, firstLevelResults);
        }
        List<Content> allContents = firstLevelResultsByComponent.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        String unresolvedFilePath = this._unresolvedFilePathWhenVar(unresolvedPath, pipelineDescriptor);
        Map<Path, List<Content>> paths = this._resultPathResolver.resolvePath(unresolvedFilePath, allContents, extraction, basePath);
        for (Path filePath : paths.keySet()) {
            List<Content> involvedContentsForPath = paths.get(filePath);
            OutputStream fileOs = Pipelines.getOutputStream(filePath);
            try {
                Pipeline pipeline = pipelineDescriptor.newPipeline(fileOs);
                try {
                    ContentHandler contentHandler = pipeline.getHandler();
                    this._withVarExecute(contentHandler, attributes, context, components, involvedContentsForPath, firstLevelResultsByComponent);
                    pipeline.serialize();
                }
                finally {
                    if (pipeline == null) continue;
                    pipeline.close();
                }
            }
            finally {
                if (fileOs == null) continue;
                fileOs.close();
            }
        }
        return paths.keySet();
    }

    private String _unresolvedFilePathWhenVar(String unresolvedFolderOrFilePath, PipelineDescriptor pipelineDescriptor) {
        if (this._resultPathResolver.isFolder(unresolvedFolderOrFilePath)) {
            return unresolvedFolderOrFilePath + "/${title}." + pipelineDescriptor.getDefaultExtension();
        }
        return unresolvedFolderOrFilePath;
    }

    private void _withVarExecute(ContentHandler contentHandler, AttributesImpl attributes, ExtractionExecutionContext context, List<TwoStepsExecutingExtractionComponent> components, List<Content> involvedContentsForPath, Map<TwoStepsExecutingExtractionComponent, List<Content>> firstLevelResultsByComponent) throws Exception {
        contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"extraction", (Attributes)attributes);
        for (TwoStepsExecutingExtractionComponent component : components) {
            List<Content> firstLevelResults = firstLevelResultsByComponent.get(component);
            List involvedFirstLevelResults = ListUtils.intersection(firstLevelResults, involvedContentsForPath);
            component.executeFor(contentHandler, involvedFirstLevelResults, context);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"extraction");
        contentHandler.endDocument();
    }
}

