/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution.pipeline;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.impl.FileSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExtractionResultsDownloadGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String[] filePaths = request.getParameterValues("file");
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("zip", "http://apache.org/cocoon/zip-archive/1.0");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"archive");
        HashSet<String> saxedPath = new HashSet<String>();
        for (String filePath : filePaths) {
            FileSource fileSource = (FileSource)this.resolver.resolveURI("ametys-home://data/extraction/" + filePath);
            String parentPath = filePath.contains("/") ? filePath.substring(0, filePath.lastIndexOf("/")) : "";
            saxedPath.addAll(this._resultFileSourceToSAX(fileSource, parentPath, saxedPath));
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"archive");
        this.contentHandler.endPrefixMapping("zip");
        this.contentHandler.endDocument();
    }

    protected Set<String> _resultFileSourceToSAX(FileSource resultSource, String parentPath, Set<String> alreadySaxedPaths) throws SourceException, SAXException {
        String currentSourcePath;
        HashSet<String> allSaxedPaths = new HashSet<String>(alreadySaxedPaths);
        String string = currentSourcePath = StringUtils.isEmpty((CharSequence)parentPath) ? resultSource.getName() : parentPath + "/" + resultSource.getName();
        if (resultSource.isCollection()) {
            Collection children = resultSource.getChildren();
            for (FileSource child : children) {
                allSaxedPaths.addAll(this._resultFileSourceToSAX(child, currentSourcePath, allSaxedPaths));
            }
        } else if (allSaxedPaths.add(currentSourcePath)) {
            AttributesImpl zipAttrs = new AttributesImpl();
            zipAttrs.addAttribute("", "name", "name", "CDATA", currentSourcePath);
            zipAttrs.addAttribute("", "src", "src", "CDATA", resultSource.getURI());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry", (Attributes)zipAttrs);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry");
        }
        return allSaxedPaths;
    }
}

