/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModel;
import org.ametys.plugins.extraction.execution.pipeline.Pipelines;
import org.ametys.plugins.extraction.execution.pipeline.impl.AbstractSerializerImpl;
import org.ametys.plugins.extraction.execution.pipeline.impl.PipelineSerializer;
import org.apache.excalibur.xml.sax.ContentHandlerProxy;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XmlPipelineSerializerModel
implements PipelineSerializerModel {
    @Override
    public String getDefaultFileExtension() {
        return "xml";
    }

    @Override
    public PipelineSerializer newSerializer(TransformerHandler handler, OutputStream out, Map<String, String> outputParameters) {
        return new XmlPipelineSerializer(handler, out, outputParameters);
    }

    private static final class XmlPipelineSerializer
    extends AbstractSerializerImpl {
        XmlPipelineSerializer(TransformerHandler handler, OutputStream out, Map<String, String> outputParameters) {
            super(handler, out);
            this._wrapHandlerToStripEOL();
            this._setOutputProps(outputParameters);
        }

        private void _wrapHandlerToStripEOL() {
            try {
                TransformerHandler transformerHandler = Pipelines.getSaxTransformerFactory().newTransformerHandler();
                StripEOLContentHandler stripWhitespacesContentHandler = new StripEOLContentHandler(transformerHandler);
                this._handler.setResult(new SAXResult((ContentHandler)((Object)stripWhitespacesContentHandler)));
                this._handler = transformerHandler;
            }
            catch (TransformerException e) {
                throw new RuntimeException("Unable to strip EOL", e);
            }
        }

        private void _setOutputProps(Map<String, String> outputParameters) {
            Properties properties = new Properties();
            properties.put("method", outputParameters.getOrDefault("method", "xml"));
            properties.put("encoding", outputParameters.getOrDefault("encoding", "UTF-8"));
            properties.put("indent", outputParameters.getOrDefault("indent", "yes"));
            properties.put("{http://xml.apache.org/xalan}indent-amount", outputParameters.getOrDefault("indent-amount", "4"));
            this._handler.getTransformer().setOutputProperties(properties);
        }

        @Override
        public void serialize() throws Exception {
        }
    }

    private static class StripEOLContentHandler
    extends ContentHandlerProxy {
        StripEOLContentHandler(ContentHandler contentHandler) {
            super(contentHandler);
        }

        public void characters(char[] ch, int start, int len) throws SAXException {
            String data = new String(ch, start, len).replaceAll("[\\r\\n]", "");
            super.characters(data.toCharArray(), 0, data.length());
        }
    }
}

