/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

// Migrate all assignments under prefix '/extraction' to prefix '/extraction-dir'

logger.info("Starting migration of extraction right assignments…");

// Get the datasource from config
let rightsDataSource = org.ametys.runtime.config.Config.getInstance().getValue('runtime.rights.datasource');
if (rightsDataSource == null)
{
    logger.info("No right datasource present, there is nothing to migrate.")
    return;
}

let handled = 1;

// migrate the root context separately to facilitate the SQL query
migrateContext("/extraction");

// Retrieve all extraction contexts with an assignements
// Do not handle table separately to circumvent SQL.query limitation
rs = SQL.query("SELECT Context FROM Rights_AllowedGroups WHERE Context LIKE '/extraction/%'"
    + " UNION SELECT Context FROM Rights_DeniedGroups WHERE Context LIKE '/extraction/%'"
    + " UNION SELECT Context FROM Rights_AllowedUsers WHERE Context LIKE '/extraction/%'"
    + " UNION SELECT Context FROM Rights_DeniedUsers WHERE Context LIKE '/extraction/%'"
    + " UNION SELECT Context FROM Rights_AllowedProfilesAnonym WHERE Context LIKE '/extraction/%'"
    + " UNION SELECT Context FROM Rights_DeniedProfilesAnonym WHERE Context LIKE '/extraction/%'"
    + " UNION SELECT Context FROM Rights_AllowedProfilesAnyCon WHERE Context LIKE '/extraction/%'"
    + " UNION SELECT Context FROM Rights_DeniedProfilesAnyCon WHERE Context LIKE '/extraction/%'",
    rightsDataSource);

while (rs.next())
{
    migrateContext(rs.getString(1));
    handled++;
}

logger.info(`End of migration of extraction right assignments. ${handled} assignments were migrated.`);

function migrateContext(oldContext)
{
    var rightsTable = [
        "Rights_AllowedGroups",
        "Rights_DeniedGroups",
        "Rights_AllowedUsers",
        "Rights_DeniedUsers",
        "Rights_AllowedProfilesAnonym",
        "Rights_DeniedProfilesAnonym",
        "Rights_AllowedProfilesAnyCon",
        "Rights_DeniedProfilesAnyCon"
    ]
    let newContext = oldContext.replace(/^(\/extraction)(?=\/|$)/, "/extraction-dir");
    
    // We don't know the table where the context is present so we migrate all the table
    for (tableId in rightsTable)
    {
        SQL.update(
            `UPDATE ${rightsTable[tableId]} SET Context='${newContext}' WHERE Context='${oldContext}'`,
            rightsDataSource
        );
    }
}
