/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ext.define('Ametys.plugins.extraction.ExtractionMessageTarget', {
    override: 'Ametys.message.MessageTarget',
    
    statics:
    {
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {Object} EXTRACTION_DEFINITION_ROOT The target is the extraction definitions' root folder itself.
         */
        EXTRACTION_DEFINITION_ROOT: 'extraction-definition-root',
        
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {Object} EXTRACTION_DEFINITION_FOLDER The target is a folder containing extraction definition files. Parameters are:
         * @property {String} EXTRACTION_DEFINITION_FOLDER.path The path into "WEB-INF/param/extraction/definitions" directory
         * @property {String} EXTRACTION_DEFINITION_FOLDER.name The name of the folder
         */
        EXTRACTION_DEFINITION_FOLDER: 'extraction-definition-folder',
        
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {Object} EXTRACTION_DEFINITION_FILE The target is an extraction definition file. See Ametys.plugins.extraction.ExtractionDefinitionFileMessageTargetFactory parameters to know more of the associated parameters.
         */
        EXTRACTION_DEFINITION_FILE: 'extraction-definition-file',
        
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {Object} EXTRACTION_NODE The target is a node of an extraction. See Ametys.plugins.extraction.ExtractionDefinitionFileMessageTargetFactory parameters to know more of the associated parameters.
         */
        EXTRACTION_NODE: 'extraction-node',
        
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {Object} EXTRACTION_RESULT_ROOT The target is the extraction result root folder.
         */
        EXTRACTION_RESULT_ROOT: 'extraction-result-root',
        
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {Object} EXTRACTION_RESULT_FILE The target is an extraction result file. Parameters are:
         * @property {String} EXTRACTION_RESULT_FILE.path The extraction's result file path
         */
        EXTRACTION_RESULT_FILE: 'extraction-result-file',
        
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {Object} EXTRACTION_RESULT_FOLDER The target is an extraction result folder. Parameters are:
         * @property {String} EXTRACTION_RESULT_FOLDER.path The extraction's result folder path
         */
        EXTRACTION_RESULT_FOLDER: 'extraction-result-folder'
    }

});