/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class helper for extraction components edition.
 * @private
 */
 Ext.define('Ametys.plugins.extraction.edition.EditExtractionComponentDialog', {
    extend: "Ametys.plugins.extraction.edition.EditExtractionNodeDialog",
    
    /**
     * @protected
     * Retrieves the form configuration for tag name
     * @return {Object} the tag name form configuration element
     */
    _getTagNameFormConfiguration: function()
    {
        var configuration = {};
        
        // Tag name field
        configuration.componentTagName = {
            type: 'string',
            label: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_TAG_LABEL}}",
            description: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_TAG_DESCRIPTION}}",
            validation: {
                regexp: '^[a-zA-Z_][a-zA-Z0-9-_.]*$',
                regexText: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_TAG_REGEX_TEXT}}"
            }
        };
        
        return configuration;
    }
 });
 