/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget to query and select one or more microthesaurii.
 */
Ext.define('Ametys.plugins.extraction.edition.widget.Microthesaurii', {
    extend: 'Ametys.form.widget.ComboBox',
    
    /**
     * @cfg {String} [thesaurusField] The relative path the thesaurus field, to
     *      allow the list of microthesaurii to be updated given the value of the
     *      thesaurus field
     */
    /**
     * @private
     * @property {String} _thesaurusFieldName The property related to {@link #cfg-thesaurusField}
     */
    
    constructor: function (config)
    {
        config.proxyStore = {
            type: 'ametys',
            role: "org.ametys.plugins.extraction.edition.EditExtractionNodeManager",
            methodName: "getMicroThesaurii",
            methodArguments: ['thesaurusId'],
            reader: {
                type: 'json',
                rootProperty: 'microthesaurii'
            }
        };
        config.autoLoad = true;
        
        this.callParent(arguments);
        
        this.thesaurusFieldName = config.thesaurusField || null;
        
        this.form.onRelativeFieldsChange([this.thesaurusFieldName], this, this._relativeFieldChange);
    },
    
    /**
     * Get the store configuration
     * @param {Object} config The current configuration object
     * @return {Object} The store configuration
     */
    getStoreCfg: function(config)
    {
        var storeCfg = this.callParent(arguments);

        Ext.apply(storeCfg, {
            listeners: {
                beforeload: {fn: this._onStoreBeforeLoad, scope: this}
            }
        });
        
        return storeCfg
    },
    
    /**
     * Set the request parameters before loading the store.
     * @param {Ext.data.Store} store The store.
     * @param {Ext.data.operation.Operation} operation The Ext.data.Operation object that will be passed to the Proxy to load the Store.
     * @private
     */
    _onStoreBeforeLoad: function(store, operation)
    {
        var relativeFields = this.form.getRelativeFields([this.thesaurusFieldName], this),
            thesaurusField = relativeFields[0];
            
        operation.setParams(Ext.apply(operation.getParams() || {}, {
            'thesaurusId': thesaurusField ? thesaurusField.getValue() : null
        }));
    },
    
    /**
     * Listener called when the value of a relative field changes
     */
    _relativeFieldChange: function()
    {
        this.getStore().load();
    }
});
