/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool displays the list of all available extraction files
 * @private
 */
Ext.define('Ametys.plugins.extraction.execution.ExtractionResultsTool', {
    extend: "Ametys.file.AbstractFileExplorerTool",
    
    /**
     * @readonly
     * @property {Boolean} extractionTabCompatible Specifies if this tool is compatible with the 'extraction tab'.
     */
    extractionTabCompatible: true,
    
    createTree: function()
    {
        return Ext.create("Ametys.plugins.extraction.execution.ExtractionResultsTree", {
            cls: 'explorer-tree',
            border: false,
            
            enableColumnResize: true,
            hideHeaders: false,
            columns: [{
                    header: "{{i18n PLUGINS_EXTRACTION_RESULTS_LIST_TOOL_COLUMN_FILE}}",
                    xtype: 'treecolumn',
                    dataIndex: 'text',
                    flex: 1,
                    minWidth: 110,
                    editor: {
                        xtype: 'textfield',
                        allowBlank: false,
                        selectOnFocus: true
                    }
                },
                {
                    header: "{{i18n PLUGINS_EXTRACTION_RESULTS_LIST_TOOL_COLUMN_LAST_MODIFIED}}",
                    hidden: false,
                    width: 130,
                    sortable: true,
                    dataIndex: 'lastModified',
                    renderer: Ext.util.Format.dateRenderer(Ext.Date.patterns.FriendlyDateTime)
                }
            ],
            
            allowNodeEditing: false,
            allowDragAndDrop: false,
            
            selModel : {
                mode: 'MULTI'
            }
        });
    },
    
    openFile: function(record)
    {
        if (record.get('type') == 'resource')
        {
            Ametys.plugins.extraction.ExtractionActions.downloadFile(record.get('downloadUrl'));
        }
    },
    
    sendCurrentSelection: function()
    {
        var selection = this._tree.getSelectionModel().getSelection();
        
        var targets = [];
        for (var i = 0 ; i < selection.length ; i++)
        {
            var target = this._tree.getMessageTargetConfiguration(selection[i], true);
            targets.push(target);
        }
        
        Ext.create("Ametys.message.Message", {
            type: Ametys.message.Message.SELECTION_CHANGED,
            
            targets: targets
        });
    },
    
    getMessageTargetIdForResource: function(type)
    {
        return Ametys.message.MessageTarget.EXTRACTION_RESULT_FILE;
    },
    
    getMessageTargetIdForCollection: function(type)
    {
        return Ametys.message.MessageTarget.EXTRACTION_RESULT_FOLDER;
    },
    
    testTarget: function(target)
    {
        return target.getId() == Ametys.message.MessageTarget.EXTRACTION_RESULT_FILE || target.getId() == Ametys.message.MessageTarget.EXTRACTION_RESULT_FOLDER
    }
});
