/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.component;

/**
 * Object representing an extraction join group information
 */
public class ExtractionClauseGroup
{
    private String _completeExpression;
    private String _expression;
    private String _variable;
    private String _fieldPath;
  
    /**
     * Retrieves the complete group expression
     * The complete group expression contains the characters used to identify the expression
     * This expression has to be replaced the join expression 
     * @return the group expression
     */
    public String getCompleteExpression()
    {
        return _completeExpression;
    }
    
    /**
     * Set the group expression
     * @param completeExpression the group expression to set
     */
    public void setCompleteExpression(String completeExpression)
    {
        this._completeExpression = completeExpression;
    }
  
    /**
     * Retrieves the group expression
     * The group expression does not contain the characters used to identify the expression
     * @return the group expression
     */
    public String getExpression()
    {
        return _expression;
    }
    
    /**
     * Set the group expression
     * @param groupExpression the group expression to set
     */
    public void setExpression(String groupExpression)
    {
        this._expression = groupExpression;
    }
    
    /**
     * Retrieves the variable
     * @return the variable
     */
    public String getVariable()
    {
        return _variable;
    }
    
    /**
     * Set the variable
     * @param variable the variable to set
     */
    public void setVariable(String variable)
    {
        this._variable = variable;
    }
    
    /**
     * Retrieves the field path
     * @return the field path
     */
    public String getFieldPath()
    {
        return _fieldPath;
    }
    
    /**
     * Set the field path
     * @param fieldPath the field path to set
     */
    public void setFieldPath(String fieldPath)
    {
        this._fieldPath = fieldPath;
    }
}
