/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.edition;

import java.util.Map;

import org.ametys.cms.workflow.CreateContentFunction;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow function to create an extraction's description.
 */
public class CreateExtractionDescriptionFunction extends CreateContentFunction
{
    /** The root node name of the plugin */
    private static final String __PLUGIN_NODE_NAME = "extraction";
    
    /** The root node name of the contents */
    private static final String __CONTENTS_NODE_NAME = RepositoryConstants.NAMESPACE_PREFIX + ":contents";
    
    @Override
    protected ModifiableTraversableAmetysObject _getContentRoot(Map transientVars) throws WorkflowException
    {
        try
        {
            ModifiableTraversableAmetysObject pluginsNode = _resolver.resolveByPath("/ametys:plugins");
            
            ModifiableTraversableAmetysObject pluginNode = _getOrCreateNode(pluginsNode, __PLUGIN_NODE_NAME, "ametys:unstructured");
            
            return _getOrCreateNode(pluginNode, __CONTENTS_NODE_NAME, "ametys:collection");
        }
        catch (AmetysRepositoryException e)
        {
            throw new AmetysRepositoryException("Unable to get the extraction root node", e);
        }
    }
    
    private ModifiableTraversableAmetysObject _getOrCreateNode(ModifiableTraversableAmetysObject parentNode, String nodeName, String nodeType) throws AmetysRepositoryException
    {
        ModifiableTraversableAmetysObject definitionsNode;
        if (parentNode.hasChild(nodeName))
        {
            definitionsNode = parentNode.getChild(nodeName);
        }
        else
        {
            definitionsNode = parentNode.createChild(nodeName, nodeType);
            parentNode.saveChanges();
        }
        return definitionsNode;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_CREATE_EXTRACTION_DESCRIPTION_FUNCTION_LABEL");
    }
}
