/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline;

/**
 * A matcher which can provide the extractions handled by a {@link Pipeline}
 */
public interface ExtractionMatcher
{
    /**
     * Checks if the extraction with the given identifier is handled by the {@link Pipeline}
     * @param extractionId the extraction identifier
     * @return <code>true</code> if the extraction is handled by the {@link Pipeline}, false otherwise
     */
    public boolean isHandled(String extractionId);
}
