/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline;

import java.io.IOException;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.FileGenerator;
import org.xml.sax.SAXException;

/**
 * {@link FileGenerator} with the source provided in parameters
 */
public class ExtractionResultFileGenerator extends FileGenerator
{
    @Override
    public void setup(SourceResolver sourceResolver, Map objModel, String src, Parameters par) throws ProcessingException, SAXException, IOException
    {
        String file = par.getParameter("file", null);
        super.setup(sourceResolver, objModel, file, par);
    }
}
