/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.rights;

import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.excalibur.source.TraversableSource;

import org.ametys.cms.ObservationConstants;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.right.ProfileAssignmentsToolClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.extraction.execution.ExtractionDAO;

/**
 * {@link ClientSideElement} for the tool displaying the profile assignments for queries
 */
public class ExtractionProfileAssignmentsToolClientSideElement extends ProfileAssignmentsToolClientSideElement
{

    /** The query DAO */
    private ExtractionDAO _extractionDAO;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _extractionDAO = (ExtractionDAO) smanager.lookup(ExtractionDAO.ROLE);
    }
    
    @Override
    protected Map<String, Object> _getEventParams(Object context, String contextIdentifier, Set<String> profileIds)
    {
        Map<String, Object> eventParams = super._getEventParams(context, contextIdentifier, profileIds);
        eventParams.put(ObservationConstants.ARGS_ACL_SOLR_CACHE_UNINFLUENTIAL, true);
        return eventParams;
    }
    
    @Override
    protected boolean hasRight(Map<String, String> rights, Object context)
    {
        try
        {
            UserIdentity user = _currentUserProvider.getUser();
            TraversableSource source = _extractionDAO.getExtractionSource((String) context);
            return _extractionDAO.canAssignRights(user, source);
        }
        catch (Exception e)
        {
            getLogger().error("Error while reading extraction file or container with following path: " + context);
        }
        return false;
    }
}
