/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.rights;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.ui.right.TargetToContextConvertor;
import org.ametys.plugins.extraction.execution.ExtractionDAO;

/**
 * Target to context convertor able to handle extraction context.
 */
public class ExtractionTargetToContextConvertor extends StaticClientSideElement implements TargetToContextConvertor
{
    private ExtractionDAO _extractionDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _extractionDAO = (ExtractionDAO) manager.lookup(ExtractionDAO.ROLE);
    }
    
    public Object convertJSContext(Object jsContext) throws UnsupportedContextException
    {
        if (jsContext instanceof String strContext)
        {
            try
            {
                return _extractionDAO.getExtractionSource(strContext);
            }
            catch (IOException e)
            {
                throw new UnsupportedContextException("Unable to get extraction file source from JS context '" + strContext + "'", e);
            }
        }
        throw new UnsupportedContextException(jsContext + "is not a valid context");
    }

}
