/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.rights;

import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.TraversableSource;

import org.ametys.core.right.RightContextConvertor;
import org.ametys.plugins.extraction.execution.ExtractionDAO;

/**
 * This implementation converts a {@link TraversableSource} into a set of extraction path
 */
public class TraversableSource2ExtractionRightContextConvertor implements RightContextConvertor, Serviceable
{
    private ExtractionDAO _extractionDAO;

    public void service(ServiceManager manager) throws ServiceException
    {
        _extractionDAO = (ExtractionDAO) manager.lookup(ExtractionDAO.ROLE);
    }
    
    @Override
    public Set<Object> convert(Object object)
    {
        if (object instanceof TraversableSource source)
        {
            String extractionRightPath = _extractionDAO.getExtractionRightPath(source);
            if (extractionRightPath != null)
            {
                return Set.of(extractionRightPath);
            }
        }
        
        return Set.of();
    }
}

