/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.flipbook;

import java.io.InputStream;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.excalibur.source.Source;

import org.ametys.core.util.FilenameUtils;

/**
 * Implementation of a {@link AbstractConvertDocument2ImagesComponent} for an external resource
 */
public class ConvertExternalResource2ImagesComponent extends AbstractConvertDocument2ImagesComponent
{   
    /** Avalon ROLE. */
    public static final String ROLE = ConvertExternalResource2ImagesComponent.class.getName();
    
    /**
     * Put the file in cache
     * @param resource the resource to cache
     * @param path The resource path
     * @param cacheDir The cache directory
     * @param name The resource name
     * @return The absolute cache path
     * @throws Exception if an error occurs while caching the file
     */
    public String doCache(Source resource, String path, String cacheDir, String name) throws Exception
    {
        // Ensure the base folder exists.
        String cachePath = _getCacheDirectory(path, cacheDir);
        
        try (InputStream is = resource.getInputStream(); InputStream is2 = resource.getInputStream())
        {
            String md5sum = DigestUtils.md5Hex(is);
            return cache(cachePath, md5sum, is2, name, path, resource.getMimeType());
        }
    }
    
    private String _getCacheDirectory(String path, String cacheDir)
    {
        StringBuilder buff = new StringBuilder();
        
        // Non-shared resources.
        buff.append("/");
        buff.append(cacheDir);
        buff.append("/resources");
        buff.append(FilenameUtils.encodePath(path));
        
        return buff.toString();
    }
}
