/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import org.ametys.cms.repository.Content;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.flipbook.ConvertContentAttachment2ImagesComponent;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.editor.AttachmentURIResolver;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.content.WebContent;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class Attachment2FlipbookUriResolver
extends AttachmentURIResolver
implements PluginAware,
Configurable {
    protected String _pluginName;
    protected String _type;
    protected ConvertContentAttachment2ImagesComponent _attachmentComponent;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._attachmentComponent = (ConvertContentAttachment2ImagesComponent)((Object)serviceManager.lookup(ConvertContentAttachment2ImagesComponent.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._type = configuration.getChild("type").getValue("attachment-content-flipbook");
    }

    public String getType() {
        return this._type;
    }

    public String resolve(String uri, boolean download, boolean absolute, boolean internal) {
        String path;
        Request request = ContextHelper.getRequest((Context)this._context);
        Content content = null;
        String contentName = null;
        String siteName = null;
        Resource resource = null;
        try {
            resource = (Resource)this._resolver.resolveById(uri);
            path = resource.getResourcePath();
            Resource ao = resource;
            while ((ao = ao.getParent()) != null && !(ao instanceof Content)) {
            }
            if (ao == null) {
                throw new IllegalArgumentException("The given attachment URI should be a content attachment.");
            }
            content = (Content)ao;
            contentName = content.getName();
            if (content instanceof WebContent) {
                siteName = ((WebContent)content).getSiteName();
            } else {
                siteName = (String)request.getAttribute("siteName");
                if (siteName == null) {
                    siteName = (String)request.getAttribute("site");
                }
            }
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Link to unexisting resource " + uri);
            return "";
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        String resultPath = this.getUriPrefix((AmetysObject)content, download, absolute, internal) + "/_attachments-flipbook/" + contentName + FilenameUtils.encodePath((String)path) + "/_contents" + FilenameUtils.encodePath((String)resource.getPath()) + "/book.html";
        if (!this._attachmentComponent.isMimeTypeSupported(resource.getMimeType())) {
            return super.resolve(uri, download, absolute, internal);
        }
        new CacheThread(resource.getId(), contentName, siteName, this._resolver, this.getLogger()).start();
        return URIUtils.encodePath((String)resultPath.toString());
    }

    public String resolveImage(String uri, int height, int width, boolean download, boolean absolute, boolean internal) {
        return this._resolveImage(uri, "", height, width, download, absolute, internal);
    }

    public String resolveBoundedImage(String uri, int maxHeight, int maxWidth, boolean download, boolean absolute, boolean internal) {
        return this._resolveImage(uri, "max", maxHeight, maxWidth, download, absolute, internal);
    }

    private String _resolveImage(String uri, String uriArgument, int height, int width, boolean download, boolean absolute, boolean internal) {
        if (height == 0 && width == 0) {
            return this.resolve(uri, download, absolute, internal);
        }
        Content content = null;
        String contentName = null;
        String siteName = null;
        Resource resource = null;
        try {
            Resource ao = resource = (Resource)this._resolver.resolveById(uri);
            while ((ao = ao.getParent()) != null && !(ao instanceof Content)) {
            }
            if (ao == null) {
                throw new IllegalArgumentException("The given attachment URI should be a content attachment.");
            }
            content = (Content)ao;
            contentName = content.getName();
            if (content instanceof WebContent) {
                siteName = ((WebContent)content).getSiteName();
            }
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Link to unexisting resource " + uri);
            return "";
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (!this._attachmentComponent.isMimeTypeSupported(resource.getMimeType())) {
            String defaultPath = this.getUriPrefix((AmetysObject)content, download, absolute, internal) + "/pages/error/thumbnail_" + uriArgument + height + "x" + width + ".png";
            return URIUtils.encodePath((String)defaultPath);
        }
        new CacheThread(resource.getId(), contentName, siteName, this._resolver, this.getLogger()).start();
        String result = this.getUriPrefix((AmetysObject)content, download, absolute, internal) + "/contents/" + contentName + "/attachments" + FilenameUtils.encodePath((String)resource.getResourcePath()) + "/pages/thumbnail_" + uriArgument + height + "x" + width + ".png";
        return URIUtils.encodePath((String)result);
    }

    protected String getUriPrefix(AmetysObject object, boolean download, boolean absolute, boolean internal) {
        boolean isInitialSite;
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = null;
        if (object instanceof SiteAwareAmetysObject) {
            siteName = ((SiteAwareAmetysObject)object).getSiteName();
        } else {
            siteName = (String)request.getAttribute("siteName");
            if (siteName == null) {
                siteName = (String)request.getAttribute("site");
            }
        }
        String initialSiteName = (String)ContextHelper.getRequest((Context)this._context).getAttribute("initialSiteName");
        boolean bl = isInitialSite = initialSiteName == null || initialSiteName.equals(siteName);
        Object uriPrefix = internal ? "cocoon://" + siteName : (absolute || !isInitialSite ? this._webPrefixHandler.getAbsoluteUriPrefix(siteName) : this._webPrefixHandler.getUriPrefix(siteName));
        uriPrefix = (String)uriPrefix + "/_plugins/" + this._pluginName + "/" + siteName;
        return uriPrefix;
    }

    private class CacheThread
    extends Thread {
        private String _resourceId;
        private String _siteName;
        private String _contentName;
        private Logger _cacheLogger;
        private AmetysObjectResolver _cacheResolver;

        public CacheThread(String resourceId, String contentName, String siteName, AmetysObjectResolver cacheResolver, Logger cacheLogger) {
            this._resourceId = resourceId;
            this._siteName = siteName;
            this._cacheLogger = cacheLogger;
            this._cacheResolver = cacheResolver;
            this._contentName = contentName;
            this.setDaemon(true);
            this.setName("FlipbookCacheAttachmentCreator");
        }

        @Override
        public void run() {
            try {
                Resource resource = (Resource)this._cacheResolver.resolveById(this._resourceId);
                Attachment2FlipbookUriResolver.this._attachmentComponent.doCache(resource, this._contentName, this._siteName);
            }
            catch (Exception e) {
                this._cacheLogger.error("An error occurred during creating cache for resource : " + this._resourceId);
            }
        }
    }
}

