/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import org.ametys.cms.data.Binary;
import org.ametys.cms.repository.Content;
import org.ametys.cms.transformation.AttributeURIResolver;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.flipbook.ConvertMetadata2ImagesComponent;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.ametysobject.ModelAwareDataAwareAmetysObject;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.editor.AttributeURIResolver;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class Attribute2FlipbookUriResolver
extends AttributeURIResolver
implements PluginAware {
    protected String _pluginName;
    protected Logger _logger;
    protected ConvertMetadata2ImagesComponent _metadataComponent;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._metadataComponent = (ConvertMetadata2ImagesComponent)((Object)serviceManager.lookup(ConvertMetadata2ImagesComponent.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public String getType() {
        return "attribute-flipbook";
    }

    public String resolve(String uri, boolean download, boolean absolute, boolean internal) {
        String fileName;
        ModelAwareDataAwareAmetysObject ametysObject;
        String path;
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = (String)request.getAttribute("site");
        try {
            AttributeURIResolver.AttributeInfo info = this._getAttributeInfo(uri, request);
            path = info.getPath();
            ametysObject = info.getAmetysObject();
            fileName = ametysObject.getName();
        }
        catch (UnknownAmetysObjectException e) {
            return "";
        }
        Binary binary = (Binary)ametysObject.getValue(path);
        if (!this._metadataComponent.isMimeTypeSupported(binary.getMimeType())) {
            return super.resolve(uri, download, absolute, internal);
        }
        String resultPath = (absolute ? this._prefixHandler.getAbsoluteUriPrefix(siteName) : this._prefixHandler.getUriPrefix(siteName)) + "/_plugins/" + this._pluginName + "/" + siteName + "/_metadata-flipbook/" + fileName + "/" + path + "/_contents" + FilenameUtils.encodePath((String)ametysObject.getPath()) + "/book.html";
        new CacheThread(ametysObject.getId(), path, siteName, this._resolver, this._logger).start();
        return URIUtils.encodePath((String)resultPath.toString());
    }

    private String _resolveImage(String uri, String uriArgument, boolean absolute) {
        ModelAwareDataAwareAmetysObject ametysObject;
        String path;
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = (String)request.getAttribute("site");
        try {
            AttributeURIResolver.AttributeInfo info = this._getAttributeInfo(uri, request);
            path = info.getPath();
            ametysObject = info.getAmetysObject();
        }
        catch (UnknownAmetysObjectException e) {
            return "";
        }
        Binary binary = (Binary)ametysObject.getValue(path);
        if (!this._metadataComponent.isMimeTypeSupported(binary.getMimeType())) {
            String defaultPath = (absolute ? this._prefixHandler.getAbsoluteUriPrefix(siteName) : this._prefixHandler.getUriPrefix(siteName)) + "/_plugins/" + this._pluginName + "/" + siteName + "/pages/error/thumbnail_" + uriArgument + ".png";
            return URIUtils.encodePath((String)defaultPath);
        }
        String result = (absolute ? this._prefixHandler.getAbsoluteUriPrefix(siteName) : this._prefixHandler.getUriPrefix(siteName)) + "/_plugins/" + this._pluginName + "/" + siteName + "/contents/" + ametysObject.getName() + "/metadatas/" + path + "/" + FilenameUtils.encodeName((String)binary.getFilename()) + "/pages/thumbnail_" + uriArgument + ".png";
        return URIUtils.encodePath((String)result);
    }

    public String resolveImage(String uri, int height, int width, boolean download, boolean absolute, boolean internal) {
        if (height == 0 && width == 0) {
            return this.resolve(uri, download, absolute, internal);
        }
        return this._resolveImage(uri, height + "x" + width, absolute);
    }

    public String resolveBoundedImage(String uri, int maxHeight, int maxWidth, boolean download, boolean absolute, boolean internal) {
        if (maxHeight == 0 && maxWidth == 0) {
            return this.resolve(uri, download, absolute, internal);
        }
        return this._resolveImage(uri, "max" + maxHeight + "x" + maxWidth, absolute);
    }

    public String resolveCroppedImage(String uri, int cropHeight, int cropWidth, boolean download, boolean absolute, boolean internal) {
        throw new UnsupportedOperationException("#resolveCroppedImage is nos supported for Attribute2FlipbookUriResolver");
    }

    public String resolveImageAsBase64(String uri, int height, int width) {
        throw new UnsupportedOperationException("#resolveImageAsBase64 is nos supported for Attribute2FlipbookUriResolver");
    }

    public String resolveBoundedImageAsBase64(String uri, int maxHeight, int maxWidth) {
        throw new UnsupportedOperationException("#resolveBoundedImageAsBase64 is nos supported for Attribute2FlipbookUriResolver");
    }

    public String resolveCroppedImageAsBase64(String uri, int cropHeight, int cropWidth) {
        throw new UnsupportedOperationException("#resolveCroppedImageAsBase64 is nos supported for Attribute2FlipbookUriResolver");
    }

    private class CacheThread
    extends Thread {
        private String _contentId;
        private String _path;
        private String _siteName;
        private Logger _cacheLogger;
        private AmetysObjectResolver _cacheResolver;

        public CacheThread(String contentId, String path, String siteName, AmetysObjectResolver cacheResolver, Logger cacheLogger) {
            this._contentId = contentId;
            this._path = path;
            this._siteName = siteName;
            this._cacheLogger = cacheLogger;
            this._cacheResolver = cacheResolver;
            this.setDaemon(true);
            this.setName("FlipbookCacheMetadataCreator");
        }

        @Override
        public void run() {
            try {
                Content content = (Content)this._cacheResolver.resolveById(this._contentId);
                Attribute2FlipbookUriResolver.this._metadataComponent.doCache(content, this._path, this._siteName);
            }
            catch (Exception e) {
                this._cacheLogger.error("An error occurred during creating cache for content : " + this._contentId);
            }
        }
    }
}

