/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.flipbook.ConvertMetadata2ImagesComponent;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class ConvertMetadata2ImagesAction
extends ServiceableAction {
    protected AmetysObjectResolver _resolver;
    protected ConvertMetadata2ImagesComponent _metadataComponent;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._metadataComponent = (ConvertMetadata2ImagesComponent)((Object)serviceManager.lookup(ConvertMetadata2ImagesComponent.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String siteName = (String)request.getAttribute("site");
        String contentPath = parameters.getParameter("content-path", null);
        try {
            Content content = (Content)this._resolver.resolveByPath(URIUtils.decode((String)contentPath));
            String metadataPath = parameters.getParameter("metadata-path", null);
            String cachePath = this._metadataComponent.doCache(content, metadataPath, siteName);
            request.setAttribute("images-base-directory", (Object)cachePath);
            HashMap<String, CallSite> result = new HashMap<String, CallSite>();
            result.put("resourceId", (CallSite)((Object)(metadataPath + "?objectId=" + content.getId())));
            return result;
        }
        catch (Exception e) {
            throw new ProcessingException("An error occurred during resolving content path " + contentPath, (Throwable)e);
        }
    }
}

