/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.ametys.core.resources.ImageResourceHandler;
import org.ametys.plugins.flipbook.ConvertExternalResource2ImagesComponent;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.Source;

public class PdfCoverResourceHandler
extends ImageResourceHandler
implements Contextualizable {
    private static final Pattern _RESOURCE_PATH_PATTERN = Pattern.compile("^(.*resources(/.+))/([^/]+?)\\.pdf\\.([^/.]+)$");
    protected ConvertExternalResource2ImagesComponent _externalResourceComponent;
    protected AmetysObjectResolver _ametysObjectResolver;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._externalResourceComponent = (ConvertExternalResource2ImagesComponent)((Object)serviceManager.lookup(ConvertExternalResource2ImagesComponent.ROLE));
        this._ametysObjectResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public Source setup(String location, Map objectModel, Parameters par, boolean readForDownload) throws IOException, ProcessingException {
        try {
            return super.setup(location, objectModel, par, readForDownload);
        }
        catch (ResourceNotFoundException e) {
            Matcher matcher = _RESOURCE_PATH_PATTERN.matcher(location);
            if (!matcher.matches()) {
                throw new ProcessingException("Invalid resource path when generating resource images", (Throwable)e);
            }
            String name = matcher.group(3) + ".pdf";
            String path = matcher.group(2) + "/" + name;
            String uri = matcher.group(1) + "/" + name;
            try {
                Source resource = this._resolver.resolveURI(uri);
                Request request = ContextHelper.getRequest((Context)this._context);
                String cachePath = this._externalResourceComponent.doCache(resource, path, "external-resources", name);
                request.setAttribute("images-base-directory", (Object)cachePath);
                Path firstPage = null;
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(cachePath, "pages"), "page*.png");){
                    firstPage = (Path)StreamSupport.stream(directoryStream.spliterator(), false).sorted(Path::compareTo).findFirst().orElseThrow();
                }
                Source src = this._resolver.resolveURI(firstPage.toString());
                if (!src.exists()) {
                    this._resolver.release(src);
                    throw new ResourceNotFoundException("Resource not found for URI : " + src.getURI());
                }
                this._source = src;
                return src;
            }
            catch (Exception ex) {
                throw new ProcessingException("Failed to get resource for URI " + location, (Throwable)ex);
            }
        }
    }
}

