<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:stringutils="org.apache.commons.lang.StringUtils"
                xmlns:urlcodec="org.apache.commons.codec.net.URLCodec"
                extension-element-prefixes="ametys resolver stringutils urlcodec">
    
    <xsl:import href="workspace:web://stylesheets/variables.xsl"/>
    <xsl:import href="workspace:web://stylesheets/template-default.xsl"/>
    
    <xsl:param name="fileUri"/>
    <xsl:param name="fileName"/>
    
    <xsl:param name="resourceType"/>
    <xsl:param name="resourceId"/>
    
    <xsl:variable name="site-uri-prefix" select="ametys:siteUriPrefix()"/>
    
    <xsl:template match="/">
        <html>
            <head>
                <meta http-equiv="X-UA-Compatible" content="IE=11" />
                <title>
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_FLIPBOOK_BOOK_TITLE"/>
                        <i18n:param name="filename"><xsl:value-of select="$fileName"/></i18n:param>
                    </i18n:translate>
                </title>
                <xsl:call-template name="head-js-jquery" ></xsl:call-template>
                <script src="{ametys:pluginResourceURL('flipbook', 'flashpageflip/jquery/modernizr.2.5.3.min.js')}" type="text/javascript"></script>
                <script src="{ametys:pluginResourceURL('flipbook', 'flashpageflip/js/hash.js')}" type="text/javascript"></script>
                <xsl:call-template name="css-flipbook" />
            </head>
            <body>
                <div id="canvas">
                   <xsl:call-template name="top-actions"/>
                   <xsl:call-template name="html-flipbook-body" />
                   <xsl:call-template name="html-flipbook-footer" />
                   <xsl:call-template name="js-flipbook" />
               </div>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="top-actions">
    	<a class="download-icon" href="{resolver:resolve($resourceType, $resourceId, true())}" title="PLUGINS_FLIPBOOK_BOOK_DOWNLOAD" i18n:attr="title"></a>
    	<div class="zoom-icon zoom-icon-in"></div>
    </xsl:template>
    
    <xsl:template name="html-flipbook-body">
        <div class="magazine-viewport">
            <div class="container">
                <div class="magazine">
                    <!-- Next button -->
                    <div ignore="1" class="next-button"></div>
                    <!-- Previous button -->
                    <div ignore="1" class="previous-button"></div>
                </div>
            </div>
            <div class="bottom">
                <div id="slider-bar" class="fpf-slider">    
                    <div id="slider"></div>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="html-flipbook-footer">
        <div id="footer">
            <div id="navcontainer">
                <ul id="navlist">
                    <li></li>
                    <li class="nav-front"><a href="javascript:frontCover();"></a></li>
                    <li class="nav-prev"><a href="javascript:previousPage();"></a></li>
                    <li id="pageNums" style="">...</li>
                    <li class="nav-next"><a href="javascript:nextPage();"></a></li>
                    <li class="nav-back"><a href="javascript:backCover();"></a></li><li style="margin-right:20px"></li>
                </ul>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="css-flipbook">
        <style type="text/css">
            .book {
                height: 800px;
            }
            
            .footer-flipbook {
                font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
                font-size:0.9em; 
                display: inline-block; 
                width:100px;
            }
        </style>
    </xsl:template>
    
    <xsl:template name="js-flipbook">
        <script type="text/javascript">
	        function loadApp() {
	            $j('#canvas').fadeIn(1000);
	            
	            var flipbook = $j('.magazine');
	              
	            // Compute the images dimension according the screen dimension, keeping image ratio and with a max width/height of 80% of the screen
	            var widthRatio = screen.width / (<xsl:value-of select="images/image[1]/@width"/>);
	            var heightRatio = screen.height / <xsl:value-of select="images/image[1]/@height"/>;
	            
                // Get the max page width and the min page height to determine final dimension of the magazine
	            var maxPageWidth = 0;
	            var minPageHeight = 0;
                
                var landscape = false;
                
	          	var tabPageNames = [];
	          	var tabLargePageNames = [];
	          	
	            <xsl:for-each select="images/image">
	            	var pageName = "<xsl:value-of select="@fileName" />";
	                tabLargePageNames.push(pageName);
                    
                    var imgWidth = Math.round(<xsl:value-of select="@width"/> * Math.min(widthRatio, heightRatio)*0.8);
                    var imgHeight = Math.round(<xsl:value-of select="@height"/> * Math.min(widthRatio, heightRatio)*0.8);
	                
	                var i = pageName.lastIndexOf(".");
	                pageName = pageName.substring(0, i) + "_" + imgHeight + "x" + imgWidth + pageName.substring(i);
	                
	                tabPageNames.push(pageName);
                    
                    landscape = landscape || (imgWidth > imgHeight);
                    
                    maxPageWidth = Math.max(maxPageWidth, imgWidth);
                    minPageHeight = minPageHeight == 0 ? imgHeight : Math.min(minPageHeight, imgHeight);
	            </xsl:for-each>          
                
	            var imagesPath = "<xsl:value-of select="concat($site-uri-prefix, '/_plugins/flipbook', images/@pagePath, '/')"/>";
	            
	            // Check if the CSS was already loaded
	            if (flipbook.width()==0 || flipbook.height()==0) {
	                setTimeout(loadApp, 10);
	                return;
	            }
	            
	            // Create the flipbook
                // If there is one or more landscape pages, magazine will display pages one by one (single mode)
                // and the dimension of the magazine will be the dimension of a landscape image
                // Otherwise, the magazine will display pages 2 by 2
                // and the dimension of the magazine will be 2*page width x page height 
	            flipbook.turn({
	                    // Magazine width
	                    width: landscape ? maxPageWidth : maxPageWidth*2, 
	                    
	                    // Magazine height
	                    height: minPageHeight,
	                    
	                    // Duration in millisecond
	                    duration: 1250,
                        
	                    // Hardware acceleration
	                    acceleration: !isChrome(),
	                    
	                    // Enables gradients
			            gradients: true,
			            
			            // Auto center this flipbook
			            autoCenter: true,
	                    
	                    // Elevation from the edge of the flipbook when turning a page
	                    elevation: 50,
	                    
	                    // The number of pages
	                    pages: '<xsl:value-of select="images/@nb-page" />',
	                    
	                    // Display mode
	                    display: landscape ? "single" : "double",
	                    
	                    // Events
	                    when: {
	                        turning: function(event, page, view) {
	                            var book = $j(this),
	                            currentPage = book.turn('page'),
                                pages = book.turn('pages');
                       
                                // Update the current URI
           
                                Hash.go('page/' +  page).update();
           
                                // Play flip sound
                                var browserName=navigator.appName;
                                if (browserName!="Microsoft Internet Explorer" &amp;&amp; browserName.indexOf("Safari")!=-1) {
                                   if(! /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
                                       flipsound.playclip();
                                   };
                                };
           
                                // Show and hide navigation buttons
                                disableControls(page);
	                        },
	        
	                        turned: function(event, page, view) {
                                disableControls(page);
                                
	                            $j(this).turn('center');
                                $j('#slider').slider().slider('value', getViewNumber($j(this), page));
           
                                //bulunulan sayfa
                                var view = $j(".magazine").turn("view").join(" - ");
           
                                if ($j(this).turn('page') == $j(this).turn('pages')){
                                   view = $j(this).turn('pages');
                                }else if($j(this).turn('page') == 1){
                                   view = 1;
                                }
           
                                $j("#pageNums").html(view + " / " + $j(this).turn('pages'));
           
                                if (page==1) { 
                                   $j(this).turn('peel', 'br');
                                }
	                        },
	        
	                        missing: function (event, pages) {
	                            // Add pages that aren't in the magazine
	                            for (var i = 0; i &lt; pages.length; i++)
	                            {
	                                addPage(pages[i], $j(this), imagesPath + tabPageNames[pages[i]-1]);
	                            }
	                        }
	                    }
	            });
	            
	            // Zoom.js
	            $j('.magazine-viewport').zoom({
	                flipbook: $j('.magazine'),
	        
	                max: function() { 
	                    return largeMagazineWidth()/$j('.magazine').width();
	                }, 
	        
	                when: {
	                    swipeLeft: function() {
	        
	                        $j(this).zoom('flipbook').turn('next');
	        
	                    },
	        
	                    swipeRight: function() {
	                        
	                        $j(this).zoom('flipbook').turn('previous');
	        
	                    },
	        
	                    resize: function(event, scale, page, pageElement) {
	                        if (scale==1)
	                        {
	                        	loadSmallPage(page, pageElement, imagesPath + tabPageNames[page-1]);
	                        }
	                        else
	                            loadLargePage(page, pageElement, imagesPath + tabLargePageNames[page-1]);
	        
	                    },
	        
	                    zoomIn: function () {
	                        $j('.made').hide();
	                        $j('.magazine').removeClass('animated').addClass('zoom-in');
	                        $j('.zoom-icon').removeClass('zoom-icon-in').addClass('zoom-icon-out');
	                        
	                        if (!window.escTip &amp;&amp; !$j.isTouch) {
	                            escTip = true;
	        
	                            $j('<div />', {'class': 'exit-message'}).
	                                html('<div>Press ESC to exit</div>').
	                                    appendTo($j('body')).
	                                    delay(2000).
	                                    animate({opacity:0}, 500, function() {
	                                        $j(this).remove();
	                                    });
	                        }
	                    },
	        
	                    zoomOut: function () {
	                       
	                        $j('.exit-message').hide();
	                        $j('.made').fadeIn();
	                        $j('.zoom-icon').removeClass('zoom-icon-out').addClass('zoom-icon-in');
	        
	                        setTimeout(function(){
	                            $j('.magazine').addClass('animated').removeClass('zoom-in');
	                            resizeViewport();
	                        }, 0);
	        
	                    }
	                }
	            });
	        
	            // Zoom event
	        
	            if ($j.isTouch)
	                $j('.magazine-viewport').bind('zoom.doubleTap', zoomTo);
	            else
	                $j('.magazine-viewport').bind('zoom.tap', zoomTo);
	        
	        
	            // Using arrow keys to turn the page
	        
	            $j(document).keydown(function(e){
	        
	                var previous = 37, next = 39, esc = 27;
	        
	                switch (e.keyCode) {
	                    case previous:
	        
	                        // left arrow
	                        $j('.magazine').turn('previous');
	                        e.preventDefault();
	        
	                    break;
	                    case next:
	        
	                        //right arrow
	                        $j('.magazine').turn('next');
	                        e.preventDefault();
	        
	                    break;
	                    case esc:
	                        
	                        $j('.magazine-viewport').zoom('zoomOut');    
	                        e.preventDefault();
	        
	                    break;
	                }
	            });
	            
	            // URIs - Format #/page/1 
	            Hash.on('^page\/([0-9]*)$', {
	                yep: function(path, parts) {
	                    var page = parts[1];
	        
	                    if (page!==undefined) {
	                        if ($j('.magazine').turn('is'))
	                            $j('.magazine').turn('page', page);
	                    }
	        
	                },
	                nop: function(path) {
	        
	                    if ($j('.magazine').turn('is'))
	                        $j('.magazine').turn('page', 1);
	                }
	            });
	            
	            $j(window).resize(function() {
	                resizeViewport();
	            }).bind('orientationchange', function() {
	                resizeViewport();
	            }); 
	        
                // Events for the next button
                $j('.next-button').bind($j.mouseEvents.over, function() {
                   
                   $j(this).addClass('next-button-hover');
           
                }).bind($j.mouseEvents.out, function() {
                   
                   $j(this).removeClass('next-button-hover');
           
                }).bind($j.mouseEvents.down, function() {
                   
                   $j(this).addClass('next-button-down');
           
                }).bind($j.mouseEvents.up, function() {
                   
                   $j(this).removeClass('next-button-down');
           
                }).click(function() {
                   
                   $j('.magazine').turn('next');
           
                });

	            // Events for the previous button
	            $j('.previous-button').bind($j.mouseEvents.over, function() {
	                
	                $j(this).addClass('previous-button-hover');
	        
	            }).bind($j.mouseEvents.out, function() {
	                
	                $j(this).removeClass('previous-button-hover');
	        
	            }).bind($j.mouseEvents.down, function() {
	                
	                $j(this).addClass('previous-button-down');
	        
	            }).bind($j.mouseEvents.up, function() {
	                
	                $j(this).removeClass('previous-button-down');
	        
	            }).click(function() {
	                
	                $j('.magazine').turn('previous');
	        
	            });
                
                var previewSrc = "<xsl:value-of select="concat($site-uri-prefix, '/_plugins/flipbook', images/@pagePath, '/preview.jpg')"/>";
                var previewWidth = <xsl:choose><xsl:when test="images/preview"><xsl:value-of select="images/preview/@width"/></xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose>;
                var previewHeight = <xsl:choose><xsl:when test="images/preview"><xsl:value-of select="images/preview/@height"/></xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose>;
                
                $j( "#slider" ).slider({
					min: 1,
					max: numberOfViews(flipbook),
			
					start: function(event, ui) {
						
						if (previewWidth > 0 &amp;&amp; previewHeight > 0)
						{
							if (!window._thumbPreview) {
								_thumbPreview = $j('&lt;div /&gt;', {'class': 'thumbnail'}).html('&lt;div&gt;&lt;/div&gt;');
								setPreview(ui.value, previewSrc, previewWidth, previewHeight);
								_thumbPreview.appendTo($j(ui.handle));
							} else
								setPreview(ui.value, previewSrc, previewWidth, previewHeight);
						}
						
						moveBar(false);
			
					},
			
					slide: function(event, ui) {
						if (previewWidth > 0 &amp;&amp; previewHeight > 0)
						{
							setPreview(ui.value, previewSrc, previewWidth, previewHeight);
						}
					},
			
					stop: function() {
			
						if (window._thumbPreview)
							_thumbPreview.removeClass('show');
						
						$j('.magazine').turn('page', Math.max(1, $j(this).slider('value')*2 - 2));
			
					}
				});
	
	            resizeViewport();
	        
	            $j('.magazine').addClass('animated');
	        }
	        
	        // Zoom icon
	        $j('.zoom-icon').bind('mouseover', function() { 
	           
	           if ($j(this).hasClass('zoom-icon-in'))
	               $j(this).addClass('zoom-icon-in-hover');
	        
	           if ($j(this).hasClass('zoom-icon-out'))
	               $j(this).addClass('zoom-icon-out-hover');
	        
	        }).bind('mouseout', function() { 
	           
	            if ($j(this).hasClass('zoom-icon-in'))
	               $j(this).removeClass('zoom-icon-in-hover');
	           
	           if ($j(this).hasClass('zoom-icon-out'))
	               $j(this).removeClass('zoom-icon-out-hover');
	        
	        }).bind('click', function() {
	        
	           if ($j(this).hasClass('zoom-icon-in'))
	               $j('.magazine-viewport').zoom('zoomIn');
	           else if ($j(this).hasClass('zoom-icon-out')) 
	               $j('.magazine-viewport').zoom('zoomOut');
	        
	        });
	        
	        $j('#canvas').hide();
	        
	        yepnope({
	            test : Modernizr.csstransforms,
	            yep: ['<xsl:value-of select="ametys:pluginResourceURL('flipbook', 'flashpageflip/js/flip.js')" />'],
	            nope: ['<xsl:value-of select="ametys:pluginResourceURL('flipbook', 'flashpageflip/js/flip.html4.js')" />', '<xsl:value-of select="ametys:pluginResourceURL('flipbook', 'css/jquery.ui.html4.css')" />'],
	            both: ['<xsl:value-of select="ametys:pluginResourceURL('flipbook', 'flashpageflip/js/zoom.js')" />', '<xsl:value-of select="ametys:pluginResourceURL('flipbook', 'css/jquery.ui.css')" />', '<xsl:value-of select="ametys:pluginResourceURL('flipbook', 'js/magazine.js')" />', '<xsl:value-of select="ametys:pluginResourceURL('flipbook', 'css/magazine.css')" />'],
 	            complete: loadApp
	        });
	        
	        function nextPage() {
	            $j(".magazine").turn("next");
	        }
	        
	        function previousPage() {
	            $j(".magazine").turn("previous");
	        }
	        
	        function frontCover() {
	            $j(".magazine").turn("page", 1);
	        }
	        
	        function backCover() {
	            $j(".magazine").turn("page", $j(".magazine").turn("pages"));
	        }
        </script>
    </xsl:template>
    
</xsl:stylesheet>
