<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="workspace:web://stylesheets/variables.xsl"/>
    
    <xsl:variable name="basePath" select="/images/@basePath"/>
    <xsl:variable name="pagePath" select="/images/@pagePath"/>
    <xsl:variable name="documentPath" select="concat(/images/@documentPath, '/', /images/@documentName)"/>
    <xsl:variable name="documentName" select="/images/@documentName"/>
    <xsl:variable name="documentSize" select="/images/@documentSize"/>
    
    <xsl:variable name="imageWidth" select="/images/@width"/>
    <xsl:variable name="imageHeight" select="/images/@height"/>
    
    <xsl:template match="/">
        <content>
            <xsl:call-template name="properties"/>
            
            <xsl:for-each select="/images/image">
                <page src="{$site-uri-prefix}/_plugins/flipbook{$basePath}/pages/{@fileName}"/>
            </xsl:for-each>
        </content>
    </xsl:template>
    
    <xsl:template name="properties">
        <xsl:attribute name="width"><xsl:value-of select="$imageWidth"/></xsl:attribute>
        <xsl:attribute name="height"><xsl:value-of select="$imageHeight"/></xsl:attribute>
        <xsl:attribute name="bgcolor">ffffff</xsl:attribute>
        <xsl:attribute name="loadercolor">ffffff</xsl:attribute>
        <xsl:attribute name="panelcolor">9ab4cf</xsl:attribute>
        <xsl:attribute name="buttoncolor">004381</xsl:attribute>
        <xsl:attribute name="textcolor">ffffff</xsl:attribute>
    </xsl:template>
    
</xsl:stylesheet>
