<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:escape="org.apache.commons.lang.StringEscapeUtils" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:math="java.lang.Math" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver math ametys escape">

    <xsl:import href="plugin:multimedia://stylesheets/content/document/document.xsl"/>    

    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-name">pdf-document</xsl:variable>    
  
    <xsl:template name="document">
        <xsl:param name="previewWidth" select="'150'"/>
        <xsl:param name="previewHeight" select="'210'"/>
        
        <xsl:if test="metadata/file">
            <div class="{$common-content-name}-preview">
                <a href="{resolver:resolve(concat(metadata/file/@type, '-flipbook'), metadata/file/@path)}" target="_blank">
    
                    <xsl:variable name="filename">
                        <xsl:choose>
                            <xsl:when test="metadata/file-text != ''"><xsl:value-of select="metadata/file-text"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="metadata/file/@filename"/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    <xsl:variable name="i18nparams"><filename><xsl:value-of select="$filename"/></filename></xsl:variable> 
                    

                    <xsl:attribute name="title">
                        <xsl:value-of select="ametys:translate('plugin.flipbook:CONTENT_PDF_DOCUMENT_BOOK_TITLE', $lang, $i18nparams)"/>
                    </xsl:attribute>
                    
                    <xsl:if test="$rendering-context = 'back'">
                        <xsl:attribute name="internal">internal</xsl:attribute>
                    </xsl:if>
                    
                    <img src="{resolver:resolveBoundedImage(concat(metadata/file/@type, '-flipbook'), metadata/file/@path, $previewHeight, $previewWidth)}">
                        <xsl:attribute name="alt">
                            <xsl:choose>
                                <xsl:when test="metadata/file-text != ''"><xsl:value-of select="metadata/file-text"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="metadata/file/@filename"/></xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                    </img>
                </a>
            </div>
       </xsl:if>
    </xsl:template>
</xsl:stylesheet>
