/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.flipbook;

/**
 * Flipbook exception, used whenever there is an error specific to the plugin.
 */
public class FlipbookException extends Exception
{

    /**
     * Flipbook exception.
     */
    public FlipbookException()
    {
        super();
    }
    
    /**
     * Flipbook exception.
     * @param message the error message 
     * @param cause the exception's cause
     */
    public FlipbookException(String message, Throwable cause)
    {
        super(message, cause);
    }
    
    /**
     * Flipbook exception.
     * @param message the error message
     */
    public FlipbookException(String message)
    {
        super(message);
    }
    
    /**
     * Flipbook exception.
     * @param cause the exception's cause
     */
    public FlipbookException(Throwable cause)
    {
        super(cause);
    }

}
