/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.ametys.plugins.flipbook.Document2ImagesConvertor;
import org.ametys.plugins.flipbook.FlipbookException;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;

public abstract class AbstractConvertDocument2ImagesComponent
extends AbstractLogEnabled
implements ThreadSafe,
Initializable,
Serviceable,
Component {
    protected AmetysObjectResolver _resolver;
    protected Document2ImagesConvertor _documentToImages;
    protected Context _cocoonContext;
    private ConcurrentMap<String, ReentrantLock> _locks;

    public void initialize() throws Exception {
        this._locks = new ConcurrentHashMap<String, ReentrantLock>();
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._documentToImages = (Document2ImagesConvertor)serviceManager.lookup(Document2ImagesConvertor.ROLE);
    }

    protected boolean isMimeTypeSupported(String mimeType) {
        return this._documentToImages.getSupportedMimeTypes().contains(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String cache(String relativeCachePath, String md5sum, InputStream documentInputStream, String documentName, String documentId, String documentMimeType) throws IOException, FlipbookException {
        if (!this.isMimeTypeSupported(documentMimeType)) {
            throw new UnsupportedOperationException("Cannot convert files of type '" + documentMimeType + "'");
        }
        File baseFolder = AbstractConvertDocument2ImagesComponent.getCacheFile(relativeCachePath);
        if (!baseFolder.exists()) {
            baseFolder.mkdirs();
        }
        String cachePath = baseFolder.getPath().replace('\\', '/');
        File md5File = new File(baseFolder, "document.md5");
        if (!md5File.isFile()) {
            md5File.createNewFile();
        }
        String oldMd5 = FileUtils.readFileToString((File)md5File, (String)"UTF-8");
        File documentFile = new File(baseFolder, "document/" + documentName);
        if (!md5sum.equals(oldMd5) || !documentFile.isFile()) {
            ReentrantLock lock = new ReentrantLock();
            ReentrantLock oldLock = this._locks.putIfAbsent(documentId, lock);
            if (oldLock != null) {
                lock = oldLock;
            }
            lock.lock();
            try {
                oldMd5 = FileUtils.readFileToString((File)md5File, (String)"UTF-8");
                if (!md5sum.equals(oldMd5) || !documentFile.isFile()) {
                    try {
                        this.createImages(documentInputStream, documentName, baseFolder);
                    }
                    catch (Throwable t) {
                        this.getLogger().error("An error occured while converting the document to images \"" + documentFile.getAbsolutePath() + "\"", t);
                        throw new FlipbookException("An error occured while converting the document to images \"" + documentFile.getAbsolutePath() + "\"", t);
                    }
                }
                FileUtils.writeStringToFile((File)md5File, (String)md5sum, (String)"UTF-8");
            }
            finally {
                lock.unlock();
                if (!lock.hasQueuedThreads()) {
                    this._locks.remove(documentId);
                }
            }
        }
        return cachePath;
    }

    protected void cleanCache(String relativeCachePath) {
        File baseFolder = AbstractConvertDocument2ImagesComponent.getCacheFile(relativeCachePath);
        if (baseFolder.exists()) {
            FileUtils.deleteQuietly((File)baseFolder);
            for (File parentFolder = baseFolder.getParentFile(); parentFolder != null && !Strings.CS.equals(parentFolder.getName(), "flipbook") && parentFolder.delete(); parentFolder = parentFolder.getParentFile()) {
            }
        }
    }

    public static File getCacheFile(String relativeCachePath) {
        return FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"flipbook", relativeCachePath});
    }

    protected void createImages(InputStream documentInputStream, String documentName, File baseFolder) throws IOException, FlipbookException {
        File documentFolder = new File(baseFolder, "document");
        documentFolder.mkdirs();
        File documentFile = new File(documentFolder, documentName);
        try (FileOutputStream fos = new FileOutputStream(documentFile);){
            IOUtils.copy((InputStream)documentInputStream, (OutputStream)fos);
            fos.flush();
        }
        File imageFolder = new File(baseFolder, "pages");
        imageFolder.mkdirs();
        FileUtils.cleanDirectory((File)imageFolder);
        this._documentToImages.convert(documentFile, imageFolder);
    }
}

