/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.flipbook.ConvertContentAttachment2ImagesComponent;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class ConvertContentAttachment2ImagesAction
extends ServiceableAction {
    protected AmetysObjectResolver _resolver;
    protected ConvertContentAttachment2ImagesComponent _attachmentComponent;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._attachmentComponent = (ConvertContentAttachment2ImagesComponent)((Object)serviceManager.lookup(ConvertContentAttachment2ImagesComponent.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String siteName = (String)request.getAttribute("site");
        String resourcePath = parameters.getParameter("path", request.getParameter("path"));
        try {
            Resource resource = (Resource)this._resolver.resolveByPath(URIUtils.decode((String)resourcePath));
            String cachePath = this._attachmentComponent.doCache(resource, parameters.getParameter("contentName", null), siteName);
            request.setAttribute("images-base-directory", (Object)cachePath);
            Content content = this._getContent(resource);
            request.setAttribute(Content.class.getName(), (Object)content);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("resourceId", resource.getId());
            return result;
        }
        catch (Exception e) {
            throw new ProcessingException("An error occurred during resolving resource path " + resourcePath, (Throwable)e);
        }
    }

    protected Content _getContent(Resource resource) {
        for (AmetysObject parent = resource.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Content)) continue;
            return (Content)parent;
        }
        return null;
    }
}

