/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.flipbook.ConvertResource2ImagesComponent;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.editor.ResourceURIResolver;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class Resource2FlipbookUriResolver
extends ResourceURIResolver
implements PluginAware,
Configurable {
    protected String _pluginName;
    protected String _type;
    protected ConvertResource2ImagesComponent _resourceComponent;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resourceComponent = (ConvertResource2ImagesComponent)((Object)serviceManager.lookup(ConvertResource2ImagesComponent.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._type = configuration.getChild("type").getValue("explorer-flipbook");
    }

    public String getType() {
        return this._type;
    }

    public String resolve(String uri, boolean download, boolean absolute, boolean internal) {
        String path;
        Resource resource = null;
        String siteName = null;
        try {
            resource = (Resource)this._resolver.resolveById(uri);
            path = this.getResourcePath(resource);
            siteName = this._getSiteName(resource);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Link to unexisting resource " + uri);
            return "";
        }
        if (!this._resourceComponent.isMimeTypeSupported(resource.getMimeType())) {
            return super.resolve(uri, download, absolute, internal);
        }
        StringBuilder result = new StringBuilder();
        result.append(this._getUriPrefix((AmetysObject)resource, download, internal, absolute, true)).append("/_").append(this.getRealPrefix(resource, "resource-flipbook")).append(FilenameUtils.encodePath((String)path)).append("/book.html");
        new CacheThread(resource.getId(), siteName, this._resolver, this.getLogger()).start();
        return URIUtils.encodePath((String)result.toString());
    }

    public String resolveImage(String uri, int height, int width, boolean download, boolean absolute, boolean internal) {
        String path;
        Resource resource = null;
        try {
            resource = (Resource)this._resolver.resolveById(uri);
            String fullPath = resource.getPath();
            path = fullPath.startsWith("/ametys:plugins/web-explorer/shared-resources") ? fullPath.substring("/ametys:plugins/web-explorer/shared-resources".length()) : resource.getResourcePath();
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Link to unexisting resource " + uri);
            return "";
        }
        if (!this._resourceComponent.isMimeTypeSupported(resource.getMimeType())) {
            String defaultPath = this._getUriPrefix((AmetysObject)resource, download, absolute, internal, true) + "/pages/error/thumbnail_" + height + "x" + width + ".png";
            return URIUtils.encodePath((String)defaultPath);
        }
        new CacheThread(resource.getId(), this._getSiteName(resource), this._resolver, this.getLogger()).start();
        String result = this._getUriPrefix((AmetysObject)resource, download, absolute, internal, false) + "/" + this.getRealPrefix(resource, "resources") + FilenameUtils.encodePath((String)path) + "/pages/thumbnail_" + height + "x" + width + ".png";
        return URIUtils.encodePath((String)result);
    }

    public String resolveBoundedImage(String uri, int maxHeight, int maxWidth, boolean download, boolean absolute, boolean internal) {
        String path;
        if (maxHeight == 0 && maxWidth == 0) {
            return this.resolve(uri, download, absolute, internal);
        }
        Resource resource = null;
        try {
            resource = (Resource)this._resolver.resolveById(uri);
            String fullPath = resource.getPath();
            path = fullPath.startsWith("/ametys:plugins/web-explorer/shared-resources") ? fullPath.substring("/ametys:plugins/web-explorer/shared-resources".length()) : resource.getResourcePath();
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Link to unexisting resource " + uri);
            return "";
        }
        if (!this._resourceComponent.isMimeTypeSupported(resource.getMimeType())) {
            String defaultPath = this._getUriPrefix((AmetysObject)resource, download, absolute, internal, true) + "/pages/error/thumbnail_max" + maxHeight + "x" + maxWidth + ".png";
            return URIUtils.encodePath((String)defaultPath);
        }
        new CacheThread(resource.getId(), this._getSiteName(resource), this._resolver, this.getLogger()).start();
        String result = this._getUriPrefix((AmetysObject)resource, download, absolute, internal, false) + "/" + this.getRealPrefix(resource, "resources") + FilenameUtils.encodePath((String)path) + "/pages/thumbnail_max" + maxHeight + "x" + maxWidth + ".png";
        return URIUtils.encodePath((String)result);
    }

    private String _getUriPrefix(AmetysObject object, boolean download, boolean absolute, boolean internal, boolean addSiteNameForSharedResources) {
        Resource resource = (Resource)object;
        String siteName = this._getSiteName(resource);
        Object uriPrefix = super.getUriPrefix(object, download, absolute, internal);
        uriPrefix = (String)uriPrefix + "/_plugins/" + this._pluginName;
        if (addSiteNameForSharedResources || !resource.getPath().startsWith("/ametys:plugins/web-explorer/shared-resources")) {
            uriPrefix = (String)uriPrefix + "/" + siteName;
        }
        return uriPrefix;
    }

    private class CacheThread
    extends Thread {
        private String _resourceId;
        private String _siteName;
        private Logger _cacheLogger;
        private AmetysObjectResolver _cacheResolver;

        public CacheThread(String resourceId, String siteName, AmetysObjectResolver cacheResolver, Logger cacheLogger) {
            this._resourceId = resourceId;
            this._siteName = siteName;
            this._cacheLogger = cacheLogger;
            this._cacheResolver = cacheResolver;
            this.setDaemon(true);
            this.setName("FlipbookCacheResourceCreator");
        }

        @Override
        public void run() {
            try {
                Resource resource = (Resource)this._cacheResolver.resolveById(this._resourceId);
                Resource2FlipbookUriResolver.this._resourceComponent.doCache(resource, this._siteName);
            }
            catch (Exception e) {
                this._cacheLogger.error("An error occurred during creating cache for resource : " + this._resourceId);
            }
        }
    }
}

