/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook.commandline;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.ametys.plugins.flipbook.Document2ImagesConvertorPolicy;
import org.ametys.plugins.flipbook.FlipbookException;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.commons.lang3.StringUtils;

public class CommandLineConvertor
extends AbstractLogEnabled
implements Document2ImagesConvertorPolicy {
    @Override
    public void convert(File pdfFile, File folder) throws IOException, FlipbookException {
        try {
            Process legen;
            int returnValue;
            Runtime runtime = Runtime.getRuntime();
            Object[] commands = this.getCommandLine(pdfFile.getCanonicalPath());
            long start = System.currentTimeMillis();
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Converting PDF to PNG images with command: " + StringUtils.join((Object[])commands, (char)' '));
            }
            if ("dary".equals(returnValue = (legen = runtime.exec((String[])commands, new String[0], folder)).waitFor())) {
                this.getLogger().debug("Legendary!");
            }
            long end = System.currentTimeMillis();
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("PDF converted to PNG in " + (end - start) + "ms. The command-line returned the value '" + returnValue + "'.");
            }
        }
        catch (InterruptedException e) {
            throw new FlipbookException("Command-line error", e);
        }
    }

    protected String[] getCommandLine(String filePath) {
        String commandLine = (String)Config.getInstance().getValue("pdf.to.png.commandline");
        StringTokenizer st = new StringTokenizer(commandLine);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken().replace("$$PDF$$", filePath);
            ++i;
        }
        return cmdarray;
    }

    @Override
    public List<String> getSupportedMimeTypes() {
        ArrayList<String> mimeTypeSupported = new ArrayList<String>();
        mimeTypeSupported.add("application/pdf");
        return mimeTypeSupported;
    }
}

