/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.flipbook;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.cms.repository.Content;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Action to convert a binary metadata into images.
 */
public class ConvertMetadata2ImagesAction extends ServiceableAction
{
    /** The ametys object resolver. */
    protected AmetysObjectResolver _resolver;
    /** The component for conversion */
    protected ConvertMetadata2ImagesComponent _metadataComponent;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
        _metadataComponent = (ConvertMetadata2ImagesComponent) serviceManager.lookup(ConvertMetadata2ImagesComponent.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        // Get the content.
        Request request = ObjectModelHelper.getRequest(objectModel);
        String siteName = (String) request.getAttribute("site");
        String contentPath = parameters.getParameter("content-path", null);

        try
        {
            // Decode contentPath as the metadataUriResolver does
            Content content = _resolver.resolveByPath(URIUtils.decode(contentPath));
            String metadataPath = parameters.getParameter("metadata-path", null);
            
            String cachePath = _metadataComponent.doCache(content, metadataPath, siteName);
            // Set the directory path in request attribute
            request.setAttribute(ImagesGenerator.IMAGES_DIRECTORY_PATH_REQUEST_ATTR, cachePath);
            
            Map<String, String> result = new HashMap<>();
            result.put("resourceId", metadataPath + "?objectId=" + content.getId());
            return result;
        }
        catch (Exception e)
        {
            throw new ProcessingException("An error occurred during resolving content path " + contentPath, e);
        }
    }
}
