/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.flipbook;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Converts a document file to PNG images, one image per page.
 * The document images file name must begin with "page".
 */
public interface Document2ImagesConvertorPolicy
{
    /**
     * Get the list of mime types the convertor can convert
     * @return The list of supported mime-types
     */
    public List<String> getSupportedMimeTypes();
    
    /**
     * Convert the given document file to PNG images, one image per page.
     * @param documentFile the document file to convert.
     * @param folder the destination folder.
     * @throws IOException if an I/O error occurs.
     * @throws FlipbookException if a document error occurs.
     */
    public void convert(File documentFile, File folder) throws IOException, FlipbookException;
    
}
