/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.flipbook;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.util.URIUtils;
import org.ametys.runtime.servlet.RuntimeConfig;

/**
 * Get the first page image for thumbnail
 */
public class GetFirstPageAction extends ServiceableAction
{
    /** Request attribute from path to images' directory */
    public static final String IMAGES_DIRECTORY_PATH_REQUEST_ATTR = "images-base-directory";
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        String path = parameters.getParameter("path");
        String sizePattern = parameters.getParameter("sizePattern");
        
        File imageFolder = FileUtils.getFile(RuntimeConfig.getInstance().getAmetysHome(), "flipbook", path, "pages");
        
        // List the image files.
        if (imageFolder.exists())
        {
            List<File> imageFiles = new ArrayList<>(FileUtils.listFiles(imageFolder, new String[] {"png"}, false));
            
            String firstPagePath = null;
            if (!imageFiles.isEmpty())
            {
                Collections.sort(imageFiles);
                
                if (imageFiles.get(0).canWrite()) // Do not continue if the image is beeing generated at this time 
                {
                    firstPagePath = imageFiles.get(0).getAbsolutePath();
                    firstPagePath = StringUtils.substringBeforeLast(firstPagePath, ".") + sizePattern + "." + StringUtils.substringAfterLast(firstPagePath, "."); 
        
                    Map<String, String> result = new HashMap<>();
                    result.put("first-page-path", URIUtils.encodePath(firstPagePath));
        
                    return result;
                }
            }
        }
        
        return null;
    }
}
