/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class AcknowledgementOfReceiptsHelper
implements Serviceable,
Component {
    public static final String ROLE = AcknowledgementOfReceiptsHelper.class.getName();
    public static final String REGEX_SENDER_MAIL = "^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,})$";
    protected AmetysObjectResolver _resolver;
    protected FormDAO _formDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
    }

    @Callable(rights={""})
    public Map<String, Object> getAcknowledgementReceiptProperties(String formId) {
        HashMap<String, Object> receiptProperties = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        this._addOptionalProperty("receipt-sender", form.getReceiptSender(), receiptProperties, Config.getInstance().getValue("smtp.mail.from"));
        this._addOptionalProperty("receipt-receiver", form.getReceiptReceiver(), receiptProperties, "entry-user");
        this._addOptionalProperty("receipt-subject", form.getReceiptSubject(), receiptProperties, null);
        this._addOptionalProperty("receipt-body", form.getReceiptBody(), receiptProperties, null);
        return receiptProperties;
    }

    private void _addOptionalProperty(String propertyName, Optional<? extends Object> value, Map<String, Object> limitProperties, Object defaultValue) {
        if (value.isPresent()) {
            limitProperties.put(propertyName, value.get());
        } else if (defaultValue != null) {
            limitProperties.put(propertyName, defaultValue);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> setAcknowledgementReceiptProperties(String formId, String sender, String receiver, String subject, String body) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        Pattern pattern = Pattern.compile(REGEX_SENDER_MAIL);
        Matcher matcher = pattern.matcher(sender);
        if (matcher.matches()) {
            form.setReceiptSender(sender);
            form.setReceiptReceiver(receiver);
            form.setReceiptSubject(subject);
            form.setReceiptBody(body);
            form.saveChanges();
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> removeEntriesReceipt(String formId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        if (form.getReceiptReceiver().isPresent()) {
            form.removeValue("receipt-sender");
            form.removeValue("receipt-receiver");
            form.removeValue("receipt-subject");
            form.removeValue("receipt-body");
            form.saveChanges();
        }
        return result;
    }
}

