/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.menu;

import java.util.List;
import java.util.Map;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class FormWorkflowButtonMenu
extends SimpleMenu {
    public static final String BUTTON_EXTENSION_ID = "org.ametys.plugins.forms.workflow.button.menu";
    private static final String _NO_WORKFLOW_ID = "ametys_no_workflow";
    protected WorkflowHelper _workflowHelper;
    private WorkflowProvider _workflowProvider;
    private boolean _galleryInitialized;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._workflowProvider = (WorkflowProvider)serviceManager.lookup(WorkflowProvider.ROLE);
        this._workflowHelper = (WorkflowHelper)serviceManager.lookup(WorkflowHelper.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        try {
            this._lazyInitializeContentViewGallery();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
        return super.getScripts(ignoreRights, contextParameters);
    }

    private synchronized void _lazyInitializeContentViewGallery() throws ConfigurationException {
        if (!this._galleryInitialized) {
            String[] workflowNames;
            SimpleMenu.GalleryGroup galleryGroup = new SimpleMenu.GalleryGroup((SimpleMenu)this, new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_BUTTON_MENU_GROUP_LABEL"));
            SimpleMenu.GalleryItem galleryItem = new SimpleMenu.GalleryItem((SimpleMenu)this);
            galleryItem.addGroup(galleryGroup);
            String noWorkflowId = this.getId() + ".ametys_no_workflow";
            Configuration confNoWorkflow = this._getWorkflowItemConfiguration(noWorkflowId, null);
            this._getGalleryItemManager().addComponent(this._pluginName, null, noWorkflowId, StaticClientSideElement.class, confNoWorkflow);
            galleryGroup.addItem(new SimpleMenu.UnresolvedItem((SimpleMenu)this, noWorkflowId, true));
            WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow();
            for (String workflowName : workflowNames = workflow.getWorkflowNames()) {
                if (!workflowName.startsWith("entry-form-")) continue;
                String id = this.getId() + "." + workflowName;
                Configuration conf = this._getWorkflowItemConfiguration(id, workflowName);
                this._getGalleryItemManager().addComponent(this._pluginName, null, id, StaticClientSideElement.class, conf);
                galleryGroup.addItem(new SimpleMenu.UnresolvedItem((SimpleMenu)this, id, true));
            }
            this._galleryItems.add(galleryItem);
            try {
                this._getGalleryItemManager().initialize();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to lookup parameter local components", (Throwable)e);
            }
        }
        this._galleryInitialized = true;
    }

    public void reset() {
        this._initializeGalleryItemManager();
        this._galleryItems.clear();
        this._galleryInitialized = false;
    }

    protected Configuration _getWorkflowItemConfiguration(String id, String workflowName) {
        DefaultConfiguration conf = new DefaultConfiguration("extension");
        conf.setAttribute("id", id);
        DefaultConfiguration classConf = new DefaultConfiguration("class");
        classConf.setAttribute("name", "Ametys.ribbon.element.ui.ButtonController");
        DefaultConfiguration workflowConf = new DefaultConfiguration("workflowName");
        workflowConf.setValue(workflowName);
        classConf.addChild((Configuration)workflowConf);
        DefaultConfiguration labelConf = new DefaultConfiguration("label");
        I18nizableText label = StringUtils.isNotBlank((CharSequence)workflowName) ? this._workflowHelper.getWorkflowLabel(workflowName) : new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORMS_EDITOR_WORKFLOW_NO_WORKFLOW");
        labelConf.setAttribute("i18n", "true");
        labelConf.setValue(label.getCatalogue() + ":" + label.getKey());
        classConf.addChild((Configuration)labelConf);
        DefaultConfiguration descConf = new DefaultConfiguration("description");
        descConf.setAttribute("i18n", "true");
        descConf.setValue(label.getCatalogue() + ":" + label.getKey());
        classConf.addChild((Configuration)descConf);
        DefaultConfiguration iconGlyphConf = new DefaultConfiguration("icon-glyph");
        iconGlyphConf.setValue("ametysicon-workflow");
        classConf.addChild((Configuration)iconGlyphConf);
        DefaultConfiguration actionConf = new DefaultConfiguration("action");
        actionConf.setValue("Ametys.plugins.forms.actions.FormsActions.setWorkflow");
        classConf.addChild((Configuration)actionConf);
        DefaultConfiguration toggleEnabledConf = new DefaultConfiguration("toggle-enabled");
        toggleEnabledConf.setValue("true");
        classConf.addChild((Configuration)toggleEnabledConf);
        Map commonConfig = (Map)this._script.getParameters().get("items-config");
        for (String tagName : commonConfig.keySet()) {
            DefaultConfiguration c = new DefaultConfiguration(tagName);
            c.setValue(String.valueOf(commonConfig.get(tagName)));
            classConf.addChild((Configuration)c);
        }
        conf.addChild((Configuration)classConf);
        return conf;
    }
}

