/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.autofill;

import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.autofill.AutofillSource;
import org.ametys.plugins.forms.question.autofill.AutofillSourceExtensionPoint;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractStaticAutoFillSource
extends AbstractLogEnabled
implements AutofillSource,
Serviceable,
Configurable,
PluginAware {
    protected String _pluginName;
    protected String _id;
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected AutofillSourceExtensionPoint _autoFillSourceExtensionPoint;
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected FormElementDefinitionHelper _formElementDefinitionHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._autoFillSourceExtensionPoint = (AutofillSourceExtensionPoint)((Object)manager.lookup(AutofillSourceExtensionPoint.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._formElementDefinitionHelper = (FormElementDefinitionHelper)((Object)manager.lookup(FormElementDefinitionHelper.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._id = configuration.getAttribute("id");
        Configuration childLabel = configuration.getChild("label");
        this._label = I18nizableText.getI18nizableTextValue((Configuration)childLabel, (String)("plugin." + this._pluginName), (String)childLabel.getValue());
        Configuration childDesc = configuration.getChild("description");
        this._description = I18nizableText.getI18nizableTextValue((Configuration)childDesc, (String)("plugin." + this._pluginName), (String)childDesc.getValue());
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
        String autofillValue = this.getAutofillValue(question);
        if (StringUtils.isNotBlank((CharSequence)autofillValue)) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"default-value", (String)autofillValue);
        }
    }
}

