/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.ametys.cms.data.File;
import org.ametys.cms.data.holder.DataHolderRelativeDisableCondition;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditions;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditionsHelper;
import org.ametys.plugins.forms.question.types.AbstractStaticFormQuestionType;
import org.ametys.plugins.forms.question.types.ConfidentialAwareQuestionType;
import org.ametys.plugins.forms.question.types.DescriptibleAwareQuestionType;
import org.ametys.plugins.forms.question.types.IllustrableAwareQuestionType;
import org.ametys.plugins.forms.question.types.MandatoryAwareQuestionType;
import org.ametys.plugins.forms.question.types.RestrictiveAwareQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemGroup;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFormQuestionType
extends AbstractStaticFormQuestionType
implements IllustrableAwareQuestionType,
DescriptibleAwareQuestionType,
MandatoryAwareQuestionType,
ConfidentialAwareQuestionType,
RestrictiveAwareQuestionType {
    protected WorkflowHelper _workflowHelper;
    protected DataHolderRelativeDisableConditionsHelper _disableConditionsHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._workflowHelper = (WorkflowHelper)manager.lookup(WorkflowHelper.ROLE);
        this._disableConditionsHelper = (DataHolderRelativeDisableConditionsHelper)manager.lookup(DataHolderRelativeDisableConditionsHelper.ROLE);
    }

    @Override
    public List<ModelItem> getRestrictiveModelItems() {
        ElementDefinition readingCheckbox = this._formElementDefinitionHelper.getElementDefinition("readingCheckbox", "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING_CHECKBOX", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING_CHECKBOX_DESC", null);
        ElementDefinition reading = this._formElementDefinitionHelper.getElementDefinition("reading", "long", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING_DESC", null);
        reading.setMultiple(true);
        HashMap<String, I18nizableText> readingWidgetParameters = new HashMap<String, I18nizableText>();
        readingWidgetParameters.put("naturalOrder", new I18nizableText("true"));
        reading.setWidgetParameters(readingWidgetParameters);
        HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
        widgetParameters.put("emptyText", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING_PLACEHOLDER"));
        reading.setWidgetParameters(widgetParameters);
        DataHolderRelativeDisableConditions disableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition condition = new DataHolderRelativeDisableCondition("readingCheckbox", DisableCondition.OPERATOR.NEQ, "true", this._disableConditionsHelper);
        disableConditions.getConditions().add(condition);
        reading.setDisableConditions((DisableConditions)disableConditions);
        ElementDefinition writingCheckbox = this._formElementDefinitionHelper.getElementDefinition("writingCheckbox", "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_WRITING_CHECKBOX", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_WRITING_CHECKBOX_DESC", null);
        ElementDefinition writing = this._formElementDefinitionHelper.getElementDefinition("writing", "long", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_WRITING", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_WRITING_DESC", (Validator)new DefaultValidator(null, true));
        writing.setMultiple(true);
        HashMap<String, I18nizableText> writingWidgetParameters = new HashMap<String, I18nizableText>();
        writingWidgetParameters.put("naturalOrder", new I18nizableText("true"));
        writing.setWidgetParameters(writingWidgetParameters);
        DataHolderRelativeDisableConditions writingDisableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition writingCondition = new DataHolderRelativeDisableCondition("writingCheckbox", DisableCondition.OPERATOR.NEQ, "true", this._disableConditionsHelper);
        writingDisableConditions.getConditions().add(writingCondition);
        writing.setDisableConditions((DisableConditions)writingDisableConditions);
        return List.of(readingCheckbox, reading, writingCheckbox, writing);
    }

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        modelItems.add(this.getDescriptionModelItem());
        modelItems.addAll(this.getRestrictiveModelItems());
        modelItems.addAll(this.getIllustrationModelItems());
        modelItems.add(this.getMandatoryModelItem());
        modelItems.add(this.getConfidentialityModelItem());
        return modelItems;
    }

    @Override
    protected List<ViewItemGroup> _getTabs(Form form) {
        if (StringUtils.isEmpty((CharSequence)form.getWorkflowName())) {
            return List.of(this._getMainTab(), this._getAdvancedTab(), this._getRulesTab(), this.getIllustrationTab(this.getModel()));
        }
        return List.of(this._getMainTab(), this._getAdvancedTab(), this._getRulesTab(), this.getRestrictiveTab(this.getModel(), form), this.getIllustrationTab(this.getModel()));
    }

    protected SimpleViewItemGroup _getMainTab() {
        SimpleViewItemGroup fieldset = super._createMainTab();
        ViewElement title = new ViewElement();
        title.setDefinition((ElementDefinition)this.getModel().getModelItem("title"));
        fieldset.addViewItem((ViewItem)title);
        fieldset.addViewItem((ViewItem)this.getDescriptionViewElement(this.getModel()));
        fieldset.addViewItem((ViewItem)this.getMandatoryViewElement(this.getModel()));
        return fieldset;
    }

    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._createAdvancedTab();
        ViewElement nameForForms = new ViewElement();
        nameForForms.setDefinition((ElementDefinition)this.getModel().getModelItem("name-for-form"));
        advancedFieldset.addViewItem((ViewItem)nameForForms);
        advancedFieldset.addViewItem(this.getConfidentialityViewElement(this.getModel()));
        return advancedFieldset;
    }

    @Override
    protected ModelItem _getEntryModelItem(FormQuestion question) {
        ModelItem item = super._getEntryModelItem(question);
        ((ElementDefinition)item).setValidator(this.getMandatoryValidator(question));
        return item;
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add("mandatory");
        fieldNames.add("readingCheckbox");
        fieldNames.add("reading");
        return fieldNames;
    }

    @Override
    public WorkflowDescriptor getWorkflowDescriptor(Form form) {
        return this._workflowHelper.getWorkflowDescriptor(form.getWorkflowName());
    }

    @Override
    public SimpleViewItemGroup getRestrictiveTab(Model model, Form form) {
        SimpleViewItemGroup restrictiveFieldset = new SimpleViewItemGroup();
        restrictiveFieldset.setName("restriction");
        restrictiveFieldset.setLabel(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_FIELDSET"));
        restrictiveFieldset.setDescription(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_FIELDSET_DESCRIPTION"));
        restrictiveFieldset.setRole("tab");
        ViewElement readingCheckbox = new ViewElement();
        readingCheckbox.setDefinition((ElementDefinition)model.getModelItem("readingCheckbox"));
        restrictiveFieldset.addViewItem((ViewItem)readingCheckbox);
        ViewElement reading = new ViewElement();
        ElementDefinition readingElementDefinition = (ElementDefinition)model.getModelItem("reading");
        readingElementDefinition.setEnumerator(this._getEnumerator(form, true));
        reading.setDefinition(readingElementDefinition);
        restrictiveFieldset.addViewItem((ViewItem)reading);
        ViewElement writingCheckbox = new ViewElement();
        writingCheckbox.setDefinition((ElementDefinition)model.getModelItem("writingCheckbox"));
        restrictiveFieldset.addViewItem((ViewItem)writingCheckbox);
        ViewElement writing = new ViewElement();
        ElementDefinition writingElementDefinition = (ElementDefinition)model.getModelItem("writing");
        writingElementDefinition.setEnumerator(this._getEnumerator(form, false));
        writing.setDefinition(writingElementDefinition);
        restrictiveFieldset.addViewItem((ViewItem)writing);
        return restrictiveFieldset;
    }

    private StaticEnumerator<Long> _getEnumerator(Form form, boolean forReading) {
        StaticEnumerator extensionEnum = new StaticEnumerator();
        WorkflowDescriptor workflowDesc = this.getWorkflowDescriptor(form);
        List steps = workflowDesc.getSteps();
        for (StepDescriptor step : steps) {
            if (!forReading && !this._hasEditAction(step)) continue;
            extensionEnum.add(new I18nizableText("plugin.forms", step.getName()), (Object)step.getId());
        }
        return extensionEnum;
    }

    private boolean _hasEditAction(StepDescriptor step) {
        List actions = step.getActions();
        return actions.stream().map(ActionDescriptor::getMetaAttributes).filter(m -> "edit".equals(m.getOrDefault("action-type", null))).findAny().isPresent();
    }

    @Override
    public boolean isReadRestricted(FormQuestion question) {
        return (Boolean)question.getValue("readingCheckbox", false, false);
    }

    @Override
    public boolean isModifiable(FormQuestion question) {
        return (Boolean)question.getValue("writingCheckbox", false, false);
    }

    @Override
    public List<Long> getReadingSteps(FormQuestion question) {
        if (question.hasValue("reading")) {
            return Arrays.asList((Long[])question.getValue("reading"));
        }
        return List.of();
    }

    @Override
    public List<Long> getWritingSteps(FormQuestion question) {
        if (question.hasValue("writing")) {
            return ListUtils.sum(Arrays.asList((Long[])question.getValue("writing")), List.of(INITIAL_WORKFLOW_ID));
        }
        return List.of(INITIAL_WORKFLOW_ID);
    }

    @Override
    public ModelItem getDescriptionModelItem() {
        return this._formElementDefinitionHelper.getElementDefinition("description", "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_DESCRIPTION", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_DESCRIPTION_DESC", null);
    }

    @Override
    public ViewElement getDescriptionViewElement(Model model) {
        ViewElement description = new ViewElement();
        description.setDefinition((ElementDefinition)model.getModelItem("description"));
        return description;
    }

    @Override
    public String getDescription(FormQuestion question) {
        return (String)question.getValue("description");
    }

    @Override
    public List<ModelItem> getIllustrationModelItems() {
        ElementDefinition illustration = this._formElementDefinitionHelper.getElementDefinition("picture", "file", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE_DESC", null);
        illustration.setWidget("edition.file");
        HashMap<String, I18nizableText> widgetParams = new HashMap<String, I18nizableText>();
        widgetParams.put("allowSources", new I18nizableText("external"));
        widgetParams.put("filter", new I18nizableText("image"));
        illustration.setWidgetParameters(widgetParams);
        ElementDefinition illustrationAlternative = this._formElementDefinitionHelper.getElementDefinition("picture-alternative", "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE_ALT", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE_ALT_DESC", null);
        return List.of(illustration, illustrationAlternative);
    }

    @Override
    public SimpleViewItemGroup getIllustrationTab(Model model) {
        SimpleViewItemGroup pictureFieldset = new SimpleViewItemGroup();
        pictureFieldset.setName("illustration");
        pictureFieldset.setLabel(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE_FIELDSET"));
        pictureFieldset.setRole("tab");
        ViewElement picture = new ViewElement();
        picture.setDefinition((ElementDefinition)model.getModelItem("picture"));
        pictureFieldset.addViewItem((ViewItem)picture);
        ViewElement pictureAlternative = new ViewElement();
        pictureAlternative.setDefinition((ElementDefinition)model.getModelItem("picture-alternative"));
        pictureFieldset.addViewItem((ViewItem)pictureAlternative);
        return pictureFieldset;
    }

    @Override
    public File getIllustration(FormQuestion question) {
        return (File)question.getValue("picture");
    }

    @Override
    public String getIllustrationAlternative(FormQuestion question) {
        return (String)question.getValue("picture-alternative");
    }

    @Override
    public ModelItem getMandatoryModelItem() {
        return this._formElementDefinitionHelper.getElementDefinition("mandatory", "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_MANDATORY", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_MANDATORY_DESC", null);
    }

    @Override
    public ViewElement getMandatoryViewElement(Model model) {
        ViewElement mandatory = new ViewElement();
        mandatory.setDefinition((ElementDefinition)model.getModelItem("mandatory"));
        return mandatory;
    }

    @Override
    public Validator getMandatoryValidator(FormQuestion question) {
        return new DefaultValidator(null, this.isMandatory(question));
    }

    @Override
    public boolean isMandatory(FormQuestion question) {
        return (Boolean)question.getValue("mandatory", false, false);
    }

    @Override
    public ModelItem getConfidentialityModelItem() {
        return this._formElementDefinitionHelper.getElementDefinition("confidentiality", "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_CONFIDENTIAL", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_CONFIDENTIAL_DESC", null);
    }

    @Override
    public ViewItem getConfidentialityViewElement(Model model) {
        ViewElement confidential = new ViewElement();
        confidential.setDefinition((ElementDefinition)model.getModelItem("confidentiality"));
        return confidential;
    }

    @Override
    public boolean isConfidential(FormQuestion formQuestion) {
        return (Boolean)formQuestion.getValue("confidentiality", false, false);
    }
}

