/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository;

import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormPageFactory;
import org.ametys.plugins.forms.repository.FormPageRule;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CopiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableDataHolder;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.NameHelper;

public class FormPage
extends DefaultTraversableAmetysObject<FormPageFactory>
implements CopiableAmetysObject {
    private static final String __PROPERTY_TITLE = "ametys-internal:title";
    private static final String __PROPERTY_RULE = "ametys-internal:rule";

    public FormPage(Node node, String parentPath, FormPageFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    public String getTitle() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_TITLE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get title property", (Throwable)e);
        }
    }

    public Form getForm() throws AmetysRepositoryException {
        return (Form)this.getParent();
    }

    public void setTitle(String title) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_TITLE, title);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set title property", (Throwable)e);
        }
    }

    public List<FormQuestion> getQuestions() throws AmetysRepositoryException {
        return this.getChildren().stream().filter(FormQuestion.class::isInstance).map(FormQuestion.class::cast).collect(Collectors.toList());
    }

    public boolean hasRule() {
        return this.hasChild(__PROPERTY_RULE);
    }

    public FormPageRule getRule() throws AmetysRepositoryException {
        return this.hasRule() ? (FormPageRule)this.getChild(__PROPERTY_RULE) : null;
    }

    public void setRule(FormPageRule.PageRuleType ruleType, String page) throws AmetysRepositoryException {
        if (!this.hasChild(__PROPERTY_RULE)) {
            this.createChild(__PROPERTY_RULE, "ametys:form-page-rule");
        }
        FormPageRule rule = this.getRule();
        rule.setType(ruleType);
        if (ruleType == FormPageRule.PageRuleType.JUMP || ruleType == FormPageRule.PageRuleType.SKIP) {
            rule.setPageId(page);
        }
    }

    public void deleteRule() {
        if (this.hasChild(__PROPERTY_RULE)) {
            ((FormPageRule)this.getChild(__PROPERTY_RULE)).remove();
        }
    }

    public FormPage copyTo(ModifiableTraversableAmetysObject parent, String name) throws AmetysRepositoryException {
        FormPage page = (FormPage)parent.createChild(name, "ametys:form-page");
        page.setTitle(this.getTitle());
        Form parentForm = page.getForm();
        boolean isSameForm = parentForm.equals((Object)this.getForm());
        for (FormQuestion question : this.getQuestions()) {
            String uniqueQuestionName = isSameForm ? parentForm.findUniqueQuestionName(question.getName()) : question.getName();
            FormQuestion questionCopy = (FormQuestion)page.createChild(NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)page, (String)uniqueQuestionName, (NameHelper.NameComputationMode)NameHelper.NameComputationMode.GENERATED_KEY, (boolean)false), "ametys:form-question");
            question.copyTo((ModifiableDataHolder)questionCopy);
            if (!isSameForm) continue;
            questionCopy.setNameForForm(uniqueQuestionName);
        }
        page.saveChanges();
        return page;
    }

    public AmetysObject copyTo(ModifiableTraversableAmetysObject parent, String name, List<String> restrictTo) throws AmetysRepositoryException {
        return this.copyTo(parent, name);
    }
}

